/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.Collections;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.style.EqualsAvoidsNullStyle;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;

public final class EqualsAvoidsNullVisitor<P>
extends JavaVisitor<P> {
    private static final MethodMatcher STRING_EQUALS = new MethodMatcher("String equals(java.lang.Object)");
    private static final MethodMatcher STRING_EQUALS_IGNORE_CASE = new MethodMatcher("String equalsIgnoreCase(java.lang.String)");
    private final EqualsAvoidsNullStyle style;

    public J visitMethodInvocation(J.MethodInvocation method, P p) {
        J j = super.visitMethodInvocation(method, p);
        if (!(j instanceof J.MethodInvocation)) {
            return j;
        }
        J.MethodInvocation m = (J.MethodInvocation)j;
        if (m.getSelect() == null) {
            return m;
        }
        if ((STRING_EQUALS.matches((MethodCall)m) || !Boolean.TRUE.equals(this.style.getIgnoreEqualsIgnoreCase()) && STRING_EQUALS_IGNORE_CASE.matches((MethodCall)m)) && m.getArguments().get(0) instanceof J.Literal && !(m.getSelect() instanceof J.Literal)) {
            J.Binary potentialNullCheck;
            J.Binary binary;
            Tree parent = (Tree)this.getCursor().getParentTreeCursor().getValue();
            if (parent instanceof J.Binary && (binary = (J.Binary)parent).getOperator() == J.Binary.Type.And && binary.getLeft() instanceof J.Binary && (this.isNullLiteral((potentialNullCheck = (J.Binary)binary.getLeft()).getLeft()) && this.matchesSelect(potentialNullCheck.getRight(), m.getSelect()) || this.isNullLiteral(potentialNullCheck.getRight()) && this.matchesSelect(potentialNullCheck.getLeft(), m.getSelect()))) {
                this.doAfterVisit((TreeVisitor)new RemoveUnnecessaryNullCheck(binary));
            }
            if (((Expression)m.getArguments().get(0)).getType() == JavaType.Primitive.Null) {
                return new J.Binary(Tree.randomId(), m.getPrefix(), Markers.EMPTY, m.getSelect(), JLeftPadded.build((Object)J.Binary.Type.Equal).withBefore(Space.SINGLE_SPACE), (Expression)((Expression)m.getArguments().get(0)).withPrefix(Space.SINGLE_SPACE), (JavaType)JavaType.Primitive.Boolean);
            }
            m = m.withSelect((Expression)((J.Literal)m.getArguments().get(0)).withPrefix(m.getSelect().getPrefix())).withArguments(Collections.singletonList((Expression)m.getSelect().withPrefix(Space.EMPTY)));
        }
        return m;
    }

    private boolean isNullLiteral(Expression expression) {
        return expression instanceof J.Literal && ((J.Literal)expression).getType() == JavaType.Primitive.Null;
    }

    private boolean matchesSelect(Expression expression, Expression select) {
        return expression.printTrimmed(this.getCursor()).replaceAll("\\s", "").equals(select.printTrimmed(this.getCursor()).replaceAll("\\s", ""));
    }

    @Generated
    public EqualsAvoidsNullVisitor(EqualsAvoidsNullStyle style) {
        this.style = style;
    }

    @Generated
    public EqualsAvoidsNullStyle getStyle() {
        return this.style;
    }

    @Generated
    public String toString() {
        return "EqualsAvoidsNullVisitor(style=" + this.getStyle() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EqualsAvoidsNullVisitor)) {
            return false;
        }
        EqualsAvoidsNullVisitor other = (EqualsAvoidsNullVisitor)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        EqualsAvoidsNullStyle this$style = this.getStyle();
        EqualsAvoidsNullStyle other$style = other.getStyle();
        return !(this$style == null ? other$style != null : !this$style.equals(other$style));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EqualsAvoidsNullVisitor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EqualsAvoidsNullStyle $style = this.getStyle();
        result = result * 59 + ($style == null ? 43 : $style.hashCode());
        return result;
    }

    private static class RemoveUnnecessaryNullCheck<P>
    extends JavaVisitor<P> {
        private final J.Binary scope;
        boolean done;

        public @Nullable J visit(@Nullable Tree tree, P p) {
            if (this.done) {
                return (J)tree;
            }
            return (J)super.visit(tree, p);
        }

        public RemoveUnnecessaryNullCheck(J.Binary scope) {
            this.scope = scope;
        }

        public J visitBinary(J.Binary binary, P p) {
            if (this.scope.isScope((Tree)binary)) {
                this.done = true;
                return binary.getRight().withPrefix(Space.EMPTY);
            }
            return super.visitBinary(binary, p);
        }
    }
}

