/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import lombok.Generated;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.ChangeFieldName;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.VariableNameUtils;
import org.openrewrite.java.marker.JavaSourceSet;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.marker.Markers;

public final class ReplaceDuplicateStringLiterals
extends Recipe {
    @Option(displayName="Apply recipe to test source set", description="Changes only apply to main by default. `includeTestSources` will apply the recipe to `test` source files.", required=false)
    @Nullable
    private final Boolean includeTestSources;

    public String getDisplayName() {
        return "Replace duplicate `String` literals";
    }

    public String getDescription() {
        return "Replaces `String` literals with a length of 5 or greater repeated a minimum of 3 times. Qualified `String` literals include final Strings, method invocations, and new class invocations. Adds a new `private static final String` or uses an existing equivalent class field. A new variable name will be generated based on the literal value if an existing field does not exist. The generated name will append a numeric value to the variable name if a name already exists in the compilation unit.";
    }

    public Set<String> getTags() {
        return new LinkedHashSet<String>(Arrays.asList("RSPEC-1192", "RSPEC-1889"));
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(2L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType("java.lang.String", Boolean.valueOf(false)), (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree instanceof JavaSourceFile) {
                    JavaSourceFile cu = (JavaSourceFile)tree;
                    Optional sourceSet = cu.getMarkers().findFirst(JavaSourceSet.class);
                    if (!(Boolean.TRUE.equals(ReplaceDuplicateStringLiterals.this.includeTestSources) || sourceSet.isPresent() && "main".equals(((JavaSourceSet)sourceSet.get()).getName()))) {
                        return cu;
                    }
                }
                return (J)super.visit(tree, (Object)ctx);
            }

            public J visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                if (classDecl.getType() == null) {
                    return classDecl;
                }
                DuplicateLiteralInfo duplicateLiteralInfo = DuplicateLiteralInfo.find(classDecl);
                Map<String, Set<J.Literal>> duplicateLiteralsMap = duplicateLiteralInfo.getDuplicateLiterals();
                if (duplicateLiteralsMap.isEmpty()) {
                    return classDecl;
                }
                Set<String> variableNames = duplicateLiteralInfo.getVariableNames();
                Map<String, String> fieldValueToFieldName = duplicateLiteralInfo.getFieldValueToFieldName();
                String classFqn = classDecl.getType().getFullyQualifiedName();
                for (String valueOfLiteral : duplicateLiteralsMap.keySet()) {
                    String variableName;
                    if (fieldValueToFieldName.containsKey(valueOfLiteral)) {
                        String classFieldName = fieldValueToFieldName.get(valueOfLiteral);
                        variableName = this.getNameWithoutShadow(classFieldName, variableNames);
                        if (StringUtils.isBlank((String)variableName)) continue;
                        if (!classFieldName.equals(variableName)) {
                            this.doAfterVisit((TreeVisitor)new ChangeFieldName(classFqn, classFieldName, variableName));
                        }
                    } else {
                        variableName = this.getNameWithoutShadow(this.transformToVariableName(valueOfLiteral), variableNames);
                        if (StringUtils.isBlank((String)variableName)) continue;
                        J.Literal replaceLiteral = ((J.Literal)duplicateLiteralsMap.get(valueOfLiteral).toArray()[0]).withId(Tree.randomId());
                        String insertStatement = "private static final String " + variableName + " = #{any(String)};";
                        if (classDecl.getKind() == J.ClassDeclaration.Kind.Type.Enum) {
                            J.EnumValueSet enumValueSet = classDecl.getBody().getStatements().stream().filter(J.EnumValueSet.class::isInstance).map(J.EnumValueSet.class::cast).findFirst().orElse(null);
                            if (enumValueSet != null) {
                                Space singleSpace = Space.build((String)" ", Collections.emptyList());
                                J.Literal literal = duplicateLiteralsMap.get(valueOfLiteral).toArray(new J.Literal[0])[0].withId(Tree.randomId());
                                J.Modifier privateModifier = new J.Modifier(Tree.randomId(), Space.build((String)"\n", Collections.emptyList()), Markers.EMPTY, null, J.Modifier.Type.Private, Collections.emptyList());
                                J.Modifier staticModifier = new J.Modifier(Tree.randomId(), singleSpace, Markers.EMPTY, null, J.Modifier.Type.Static, Collections.emptyList());
                                J.Modifier finalModifier = new J.Modifier(Tree.randomId(), singleSpace, Markers.EMPTY, null, J.Modifier.Type.Final, Collections.emptyList());
                                J.VariableDeclarations variableDeclarations = (J.VariableDeclarations)this.autoFormat((J)new J.VariableDeclarations(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), Arrays.asList(privateModifier, staticModifier, finalModifier), (TypeTree)new J.Identifier(Tree.randomId(), singleSpace, Markers.EMPTY, Collections.emptyList(), "String", (JavaType)JavaType.ShallowClass.build((String)"java.lang.String"), null), null, Collections.emptyList(), Collections.singletonList(JRightPadded.build((Object)new J.VariableDeclarations.NamedVariable(Tree.randomId(), Space.EMPTY, Markers.EMPTY, new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), variableName, (JavaType)JavaType.ShallowClass.build((String)"java.lang.String"), null), Collections.emptyList(), JLeftPadded.build((Object)literal).withBefore(singleSpace), null)))), ctx, new Cursor(this.getCursor(), (Object)classDecl.getBody()));
                                ArrayList<Object> statements = new ArrayList<Object>(classDecl.getBody().getStatements().size() + 1);
                                boolean addedNewStatement = false;
                                for (Statement statement : classDecl.getBody().getStatements()) {
                                    if (!(statement instanceof J.EnumValueSet) && !addedNewStatement) {
                                        statements.add(variableDeclarations);
                                        addedNewStatement = true;
                                    }
                                    statements.add(statement);
                                }
                                classDecl = classDecl.withBody(classDecl.getBody().withStatements(statements));
                            }
                        } else {
                            classDecl = classDecl.withBody((J.Block)JavaTemplate.builder((String)insertStatement).build().apply(new Cursor(this.getCursor(), (Object)classDecl.getBody()), classDecl.getBody().getCoordinates().firstStatement(), new Object[]{replaceLiteral}));
                        }
                    }
                    variableNames.add(variableName);
                    this.doAfterVisit((TreeVisitor)new ReplaceStringLiterals(classDecl, variableName, duplicateLiteralsMap.get(valueOfLiteral)));
                }
                return classDecl;
            }

            private String getNameWithoutShadow(String name, Set<String> variableNames) {
                String transformedName;
                String newName = transformedName = this.transformToVariableName(name);
                int append = 0;
                while (variableNames.contains(newName)) {
                    newName = transformedName + "_" + ++append;
                }
                return newName;
            }

            private String transformToVariableName(String valueOfLiteral) {
                boolean prevIsLower = false;
                boolean prevIsCharacter = false;
                StringBuilder newName = new StringBuilder();
                for (int i = 0; i < valueOfLiteral.length(); ++i) {
                    char c = valueOfLiteral.charAt(i);
                    if (i > 0 && newName.lastIndexOf("_") != newName.length() - 1 && (Character.isUpperCase(c) && prevIsLower || !prevIsCharacter)) {
                        newName.append("_");
                    }
                    if (!(prevIsCharacter = Character.isLetterOrDigit(c))) continue;
                    if (newName.length() == 0 && Character.isDigit(c)) {
                        newName.append("A_");
                    }
                    newName.append(Character.toUpperCase(c));
                    prevIsLower = Character.isLowerCase(c);
                }
                return VariableNameUtils.normalizeName((String)newName.toString());
            }
        });
    }

    private static boolean isPrivateStaticFinalVariable(J.VariableDeclarations declaration) {
        return declaration.hasModifier(J.Modifier.Type.Private) && declaration.hasModifier(J.Modifier.Type.Static) && declaration.hasModifier(J.Modifier.Type.Final);
    }

    @Generated
    public ReplaceDuplicateStringLiterals(Boolean includeTestSources) {
        this.includeTestSources = includeTestSources;
    }

    @Generated
    public Boolean getIncludeTestSources() {
        return this.includeTestSources;
    }

    @Generated
    public String toString() {
        return "ReplaceDuplicateStringLiterals(includeTestSources=" + this.getIncludeTestSources() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReplaceDuplicateStringLiterals)) {
            return false;
        }
        ReplaceDuplicateStringLiterals other = (ReplaceDuplicateStringLiterals)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$includeTestSources = this.getIncludeTestSources();
        Boolean other$includeTestSources = other.getIncludeTestSources();
        return !(this$includeTestSources == null ? other$includeTestSources != null : !((Object)this$includeTestSources).equals(other$includeTestSources));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ReplaceDuplicateStringLiterals;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $includeTestSources = this.getIncludeTestSources();
        result = result * 59 + ($includeTestSources == null ? 43 : ((Object)$includeTestSources).hashCode());
        return result;
    }

    private static final class ReplaceStringLiterals
    extends JavaVisitor<ExecutionContext> {
        private final J.ClassDeclaration isClass;
        private final String variableName;
        private final Set<J.Literal> literals;

        public J visitLiteral(J.Literal literal, ExecutionContext ctx) {
            if (this.literals.contains(literal)) {
                assert (this.isClass.getType() != null);
                return new J.Identifier(Tree.randomId(), literal.getPrefix(), literal.getMarkers(), Collections.emptyList(), this.variableName, (JavaType)JavaType.Primitive.String, new JavaType.Variable(null, Flag.flagsToBitMap(new HashSet<Flag>(Arrays.asList(Flag.Private, Flag.Static, Flag.Final))), this.variableName, (JavaType)this.isClass.getType(), (JavaType)JavaType.Primitive.String, Collections.emptyList()));
            }
            return literal;
        }

        @Generated
        public ReplaceStringLiterals(J.ClassDeclaration isClass, String variableName, Set<J.Literal> literals) {
            this.isClass = isClass;
            this.variableName = variableName;
            this.literals = literals;
        }

        @Generated
        public J.ClassDeclaration getIsClass() {
            return this.isClass;
        }

        @Generated
        public String getVariableName() {
            return this.variableName;
        }

        @Generated
        public Set<J.Literal> getLiterals() {
            return this.literals;
        }

        @Generated
        public String toString() {
            return "ReplaceDuplicateStringLiterals.ReplaceStringLiterals(isClass=" + this.getIsClass() + ", variableName=" + this.getVariableName() + ", literals=" + this.getLiterals() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReplaceStringLiterals)) {
                return false;
            }
            ReplaceStringLiterals other = (ReplaceStringLiterals)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            J.ClassDeclaration this$isClass = this.getIsClass();
            J.ClassDeclaration other$isClass = other.getIsClass();
            if (this$isClass == null ? other$isClass != null : !this$isClass.equals(other$isClass)) {
                return false;
            }
            String this$variableName = this.getVariableName();
            String other$variableName = other.getVariableName();
            if (this$variableName == null ? other$variableName != null : !this$variableName.equals(other$variableName)) {
                return false;
            }
            Set<J.Literal> this$literals = this.getLiterals();
            Set<J.Literal> other$literals = other.getLiterals();
            return !(this$literals == null ? other$literals != null : !((Object)this$literals).equals(other$literals));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ReplaceStringLiterals;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            J.ClassDeclaration $isClass = this.getIsClass();
            result = result * 59 + ($isClass == null ? 43 : $isClass.hashCode());
            String $variableName = this.getVariableName();
            result = result * 59 + ($variableName == null ? 43 : $variableName.hashCode());
            Set<J.Literal> $literals = this.getLiterals();
            result = result * 59 + ($literals == null ? 43 : ((Object)$literals).hashCode());
            return result;
        }
    }

    private static final class DuplicateLiteralInfo {
        private final Set<String> variableNames;
        private final Map<String, String> fieldValueToFieldName;
        private final Map<String, Set<J.Literal>> literalsMap = new HashMap<String, Set<J.Literal>>();

        public Map<String, Set<J.Literal>> getDuplicateLiterals() {
            TreeMap<String, Set<J.Literal>> filteredMap = new TreeMap<String, Set<J.Literal>>(Comparator.reverseOrder());
            for (String valueOfLiteral : this.literalsMap.keySet()) {
                if (this.literalsMap.get(valueOfLiteral).size() < 3) continue;
                filteredMap.put(valueOfLiteral, this.literalsMap.get(valueOfLiteral));
            }
            return filteredMap;
        }

        public static DuplicateLiteralInfo find(J.ClassDeclaration inClass) {
            final DuplicateLiteralInfo result = new DuplicateLiteralInfo(new LinkedHashSet<String>(), new LinkedHashMap<String, String>());
            new JavaIsoVisitor<Integer>(){

                public J.Annotation visitAnnotation(J.Annotation annotation, Integer integer) {
                    return annotation;
                }

                public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, Integer integer) {
                    J.VariableDeclarations.NamedVariable v = super.visitVariable(variable, (Object)integer);
                    Cursor parentScope = this.getCursor().dropParentUntil(is -> is instanceof J.ClassDeclaration || is instanceof J.MethodDeclaration);
                    J.VariableDeclarations declaration = (J.VariableDeclarations)this.getCursor().firstEnclosing(J.VariableDeclarations.class);
                    if (parentScope.getValue() instanceof J.MethodDeclaration || parentScope.getValue() instanceof J.ClassDeclaration && declaration != null && (!ReplaceDuplicateStringLiterals.isPrivateStaticFinalVariable(declaration) || !(v.getInitializer() instanceof J.Literal) || !(((J.Literal)v.getInitializer()).getValue() instanceof String))) {
                        result.variableNames.add(v.getSimpleName());
                    }
                    if (parentScope.getValue() instanceof J.ClassDeclaration && declaration != null && ReplaceDuplicateStringLiterals.isPrivateStaticFinalVariable(declaration) && v.getInitializer() instanceof J.Literal && ((J.Literal)v.getInitializer()).getValue() instanceof String) {
                        String value = (String)((J.Literal)v.getInitializer()).getValue();
                        result.fieldValueToFieldName.putIfAbsent(value, v.getSimpleName());
                    }
                    return v;
                }

                public J.Literal visitLiteral(J.Literal literal, Integer integer) {
                    if (JavaType.Primitive.String.equals((Object)literal.getType()) && literal.getValue() instanceof String && ((String)literal.getValue()).length() >= 5) {
                        Cursor parent = this.getCursor().dropParentUntil(is -> is instanceof J.ClassDeclaration || is instanceof J.Annotation || is instanceof J.VariableDeclarations || is instanceof J.NewClass || is instanceof J.MethodInvocation);
                        if (parent.getValue() instanceof J.NewClass && parent.firstEnclosing(J.EnumValueSet.class) != null) {
                            return literal;
                        }
                        if (parent.getValue() instanceof J.VariableDeclarations && ((J.VariableDeclarations)parent.getValue()).hasModifier(J.Modifier.Type.Final) && (!((J.VariableDeclarations)parent.getValue()).hasModifier(J.Modifier.Type.Private) || !((J.VariableDeclarations)parent.getValue()).hasModifier(J.Modifier.Type.Static)) || parent.getValue() instanceof J.NewClass || parent.getValue() instanceof J.MethodInvocation) {
                            result.literalsMap.computeIfAbsent((String)literal.getValue(), k -> new HashSet());
                            ((Set)result.literalsMap.get((String)literal.getValue())).add(literal);
                        }
                    }
                    return literal;
                }
            }.visit((Tree)inClass, (Object)0);
            return result;
        }

        @Generated
        public DuplicateLiteralInfo(Set<String> variableNames, Map<String, String> fieldValueToFieldName) {
            this.variableNames = variableNames;
            this.fieldValueToFieldName = fieldValueToFieldName;
        }

        @Generated
        public Set<String> getVariableNames() {
            return this.variableNames;
        }

        @Generated
        public Map<String, String> getFieldValueToFieldName() {
            return this.fieldValueToFieldName;
        }

        @Generated
        public Map<String, Set<J.Literal>> getLiteralsMap() {
            return this.literalsMap;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DuplicateLiteralInfo)) {
                return false;
            }
            DuplicateLiteralInfo other = (DuplicateLiteralInfo)o;
            Set<String> this$variableNames = this.getVariableNames();
            Set<String> other$variableNames = other.getVariableNames();
            if (this$variableNames == null ? other$variableNames != null : !((Object)this$variableNames).equals(other$variableNames)) {
                return false;
            }
            Map<String, String> this$fieldValueToFieldName = this.getFieldValueToFieldName();
            Map<String, String> other$fieldValueToFieldName = other.getFieldValueToFieldName();
            if (this$fieldValueToFieldName == null ? other$fieldValueToFieldName != null : !((Object)this$fieldValueToFieldName).equals(other$fieldValueToFieldName)) {
                return false;
            }
            Map<String, Set<J.Literal>> this$literalsMap = this.getLiteralsMap();
            Map<String, Set<J.Literal>> other$literalsMap = other.getLiteralsMap();
            return !(this$literalsMap == null ? other$literalsMap != null : !((Object)this$literalsMap).equals(other$literalsMap));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Set<String> $variableNames = this.getVariableNames();
            result = result * 59 + ($variableNames == null ? 43 : ((Object)$variableNames).hashCode());
            Map<String, String> $fieldValueToFieldName = this.getFieldValueToFieldName();
            result = result * 59 + ($fieldValueToFieldName == null ? 43 : ((Object)$fieldValueToFieldName).hashCode());
            Map<String, Set<J.Literal>> $literalsMap = this.getLiteralsMap();
            result = result * 59 + ($literalsMap == null ? 43 : ((Object)$literalsMap).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ReplaceDuplicateStringLiterals.DuplicateLiteralInfo(variableNames=" + this.getVariableNames() + ", fieldValueToFieldName=" + this.getFieldValueToFieldName() + ", literalsMap=" + this.getLiteralsMap() + ")";
        }
    }
}

