/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.staticanalysis.LambdaBlockToExpression;

@Incubating(since="7.23.0")
public class RemoveRedundantTypeCast
extends Recipe {
    public String getDisplayName() {
        return "Remove redundant casts";
    }

    public String getDescription() {
        return "Removes unnecessary type casts. Does not currently check casts in lambdas, class constructors, and method invocations.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(2L);
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-1905");
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){

            public J visitTypeCast(J.TypeCast typeCast, ExecutionContext ctx) {
                J visited = super.visitTypeCast(typeCast, (Object)ctx);
                if (!(visited instanceof J.TypeCast)) {
                    return visited;
                }
                Cursor parent = this.getCursor().dropParentUntil(is -> is instanceof J.VariableDeclarations || is instanceof J.Lambda || is instanceof J.Return || is instanceof MethodCall || is instanceof J.MethodDeclaration || is instanceof J.ClassDeclaration || is instanceof JavaSourceFile);
                J parentValue = (J)parent.getValue();
                JavaType targetType = null;
                if (parentValue instanceof J.VariableDeclarations) {
                    targetType = ((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)parentValue).getVariables().get(0)).getType();
                } else if (parentValue instanceof MethodCall) {
                    MethodCall methodCall = (MethodCall)parentValue;
                    JavaType.Method methodType = methodCall.getMethodType();
                    if (methodType == null || LambdaBlockToExpression.hasMethodOverloading(methodType)) {
                        return visited;
                    }
                    if (!methodType.getParameterTypes().isEmpty()) {
                        List arguments = methodCall.getArguments();
                        for (int i = 0; i < arguments.size(); ++i) {
                            Expression arg = (Expression)arguments.get(i);
                            if (arg != typeCast) continue;
                            targetType = this.getParameterType(methodType, i);
                            break;
                        }
                    }
                } else if (parentValue instanceof J.Return && ((J.Return)parentValue).getExpression() == typeCast && (parent = parent.dropParentUntil(is -> is instanceof J.Lambda || is instanceof J.MethodDeclaration || is instanceof J.ClassDeclaration || is instanceof JavaSourceFile)).getValue() instanceof J.MethodDeclaration && ((J.MethodDeclaration)parent.getValue()).getMethodType() != null) {
                    JavaType.Method methodType = ((J.MethodDeclaration)parent.getValue()).getMethodType();
                    targetType = methodType.getReturnType();
                }
                J.TypeCast visitedTypeCast = (J.TypeCast)visited;
                JavaType expressionType = visitedTypeCast.getExpression().getType();
                JavaType castType = visitedTypeCast.getType();
                if (targetType == null || (targetType instanceof JavaType.Primitive || castType instanceof JavaType.Primitive) && castType != expressionType || (typeCast.getExpression() instanceof J.Lambda || typeCast.getExpression() instanceof J.MemberReference) && castType instanceof JavaType.Parameterized) {
                    return visitedTypeCast;
                }
                if (!(targetType instanceof JavaType.Array) && TypeUtils.isOfClassType((JavaType)targetType, (String)"java.lang.Object") || TypeUtils.isOfType((JavaType)targetType, (JavaType)expressionType) || TypeUtils.isAssignableTo((JavaType)targetType, (JavaType)expressionType)) {
                    return visitedTypeCast.getExpression().withPrefix(visitedTypeCast.getPrefix());
                }
                return visitedTypeCast;
            }

            private JavaType getParameterType(JavaType.Method method, int arg) {
                List parameterTypes = method.getParameterTypes();
                if (parameterTypes.size() > arg) {
                    return (JavaType)parameterTypes.get(arg);
                }
                JavaType type = (JavaType)parameterTypes.get(parameterTypes.size() - 1);
                return type instanceof JavaType.Array ? ((JavaType.Array)type).getElemType() : type;
            }
        };
    }
}

