/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class RedundantFileCreation
extends Recipe {
    public String getDisplayName() {
        return "Redundant file creation";
    }

    public String getDescription() {
        return "Remove unnecessary intermediate creations of files.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType("java.io.FileInputStream", Boolean.valueOf(true)), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.NewClass visitNewClass(J.NewClass newClass, ExecutionContext executionContext) {
                J.NewClass n = super.visitNewClass(newClass, (Object)executionContext);
                if (n.getClazz() != null && TypeUtils.isOfClassType((JavaType)n.getClazz().getType(), (String)"java.io.FileInputStream")) {
                    n = n.withArguments(ListUtils.map((List)n.getArguments(), arg -> {
                        J.NewClass newClassArg;
                        if (arg instanceof J.NewClass && (newClassArg = (J.NewClass)arg).getClazz() != null && TypeUtils.isOfClassType((JavaType)newClassArg.getClazz().getType(), (String)"java.io.File") && newClassArg.getArguments().size() == 1 && !(newClassArg.getArguments().get(0) instanceof J.Empty)) {
                            this.maybeRemoveImport("java.io.File");
                            return (Expression)newClassArg.getArguments().get(0);
                        }
                        return arg;
                    }));
                }
                return n;
            }
        });
    }
}

