/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.Iterator;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class UseForEachRemoveInsteadOfSetRemoveAll
extends Recipe {
    public String getDisplayName() {
        return "Replace `java.util.Set#removeAll(java.util.Collection)` with `java.util.Collection#forEach(Set::remove)`";
    }

    public String getDescription() {
        return "Using `java.util.Collection#forEach(Set::remove)` rather than `java.util.Set#removeAll(java.util.Collection)` may improve performance due to a possible O(n^2) complexity.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final MethodMatcher removeAll = new MethodMatcher("java.util.Set removeAll(java.util.Collection)");
        return Preconditions.check((TreeVisitor)new UsesMethod(removeAll), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
                J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)executionContext);
                if (removeAll.matches((MethodCall)mi) && !this.returnValueIsUsed()) {
                    mi = (J.MethodInvocation)JavaTemplate.builder((String)"#{any(java.util.Collection)}.forEach(#{any(java.util.Set)}::remove)").build().apply(this.updateCursor((Tree)mi), mi.getCoordinates().replace(), new Object[]{mi.getArguments().get(0), mi.getSelect()});
                }
                return mi;
            }

            private boolean returnValueIsUsed() {
                Iterator cIterator = this.getCursor().getPathAsCursors();
                while (cIterator.hasNext()) {
                    Cursor p = (Cursor)cIterator.next();
                    if (p.getValue() instanceof J.ClassDeclaration || p.getValue() instanceof J.Block || p.getValue() instanceof J.Lambda) {
                        return false;
                    }
                    if (!(p.getValue() instanceof J.ControlParentheses) && !(p.getValue() instanceof J.Return) && !(p.getValue() instanceof J.VariableDeclarations) && !(p.getValue() instanceof J.Assignment)) continue;
                    return true;
                }
                return true;
            }
        });
    }
}

