/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.NameCaseConvention;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.staticanalysis.RenameToCamelCase;

public class RenameLocalVariablesToCamelCase
extends Recipe {
    public String getDisplayName() {
        return "Reformat local variable names to camelCase";
    }

    public String getDescription() {
        return "Reformat local variable and method parameter names to camelCase to comply with Java naming convention. The recipe will not rename variables declared in for loop controls or catches with a single character. The first character is set to lower case and existing capital letters are preserved. Special characters that are allowed in java field names `$` and `_` are removed. If a special character is removed the next valid alphanumeric will be capitalized. Currently, does not support renaming members of classes. The recipe will not rename a variable if the result already exists in the class, conflicts with a java reserved keyword, or the result is blank.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-117");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(2L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new RenameToCamelCase(){

            @Override
            protected boolean shouldRename(Set<String> hasNameKey, J.VariableDeclarations.NamedVariable variable, String toName) {
                if (toName.isEmpty() || !Character.isAlphabetic(toName.charAt(0))) {
                    return false;
                }
                return !hasNameKey.contains(toName);
            }

            public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, ExecutionContext ctx) {
                Cursor parentScope = this.getCursorToParentScope(this.getCursor());
                if (!(parentScope.getParent() != null && (parentScope.getParent().getValue() instanceof J.ClassDeclaration || parentScope.getValue() instanceof J.ClassDeclaration) || parentScope.getParent().getValue() instanceof J.NewClass || parentScope.getValue() instanceof J.ForLoop.Control || (parentScope.getValue() instanceof J.Try.Catch || parentScope.getValue() instanceof J.MultiCatch) && variable.getSimpleName().length() == 1)) {
                    if (!NameCaseConvention.LOWER_CAMEL.matches(variable.getSimpleName())) {
                        String toName = NameCaseConvention.LOWER_CAMEL.format(variable.getSimpleName());
                        this.renameVariable(variable, toName);
                    } else {
                        this.hasNameKey(variable.getSimpleName());
                    }
                }
                return variable;
            }

            public J.Identifier visitIdentifier(J.Identifier identifier, ExecutionContext ctx) {
                this.hasNameKey(identifier.getSimpleName());
                return identifier;
            }

            private Cursor getCursorToParentScope(Cursor cursor) {
                return cursor.dropParentUntil(is -> is instanceof J.ClassDeclaration || is instanceof J.Block || is instanceof J.MethodDeclaration || is instanceof J.ForLoop || is instanceof J.ForEachLoop || is instanceof J.ForLoop.Control || is instanceof J.Case || is instanceof J.Try || is instanceof J.Try.Catch || is instanceof J.MultiCatch || is instanceof J.Lambda || is instanceof JavaSourceFile);
            }
        };
    }
}

