/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.Collections;
import java.util.Scanner;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;

final class JavaElementFactory {
    JavaElementFactory() {
    }

    static J.MemberReference newStaticMethodReference(JavaType.Method method, boolean qualified, @Nullable JavaType type) {
        JavaType.FullyQualified declaringType = method.getDeclaringType();
        Expression containing = JavaElementFactory.className((JavaType)declaringType, qualified);
        return JavaElementFactory.newInstanceMethodReference(method, containing, type);
    }

    static Expression className(JavaType type, boolean qualified) {
        Object name = null;
        String qualifiedName = type instanceof JavaType.FullyQualified ? (qualified ? ((JavaType.FullyQualified)type).getFullyQualifiedName() : ((JavaType.FullyQualified)type).getClassName()) : type.toString();
        Scanner scanner = new Scanner(qualifiedName.replace('$', '.')).useDelimiter("\\.");
        int i = 0;
        while (scanner.hasNext()) {
            String part = scanner.next();
            JavaType typeOfContaining = scanner.hasNext() ? null : type;
            name = i > 0 ? new J.FieldAccess(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (Expression)name, new JLeftPadded(Space.EMPTY, (Object)new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, part, typeOfContaining, null), Markers.EMPTY), typeOfContaining) : new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, part, type, null);
            ++i;
        }
        assert (name != null);
        return name;
    }

    static J.MemberReference newInstanceMethodReference(JavaType.Method method, Expression containing, @Nullable JavaType type) {
        return new J.MemberReference(Tree.randomId(), Space.EMPTY, Markers.EMPTY, new JRightPadded((Object)containing, Space.EMPTY, Markers.EMPTY), null, new JLeftPadded(Space.EMPTY, (Object)new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, method.getName(), null, null), Markers.EMPTY), type, method, null);
    }

    @Nullable
    static J.FieldAccess newClassLiteral(@Nullable JavaType type, boolean qualified) {
        JavaType.Class classType = JavaElementFactory.getClassType(type);
        if (classType == null) {
            return null;
        }
        JavaType.Parameterized parameterized = new JavaType.Parameterized(null, (JavaType.FullyQualified)classType, Collections.singletonList(type));
        return new J.FieldAccess(Tree.randomId(), Space.EMPTY, Markers.EMPTY, JavaElementFactory.className(type, qualified), new JLeftPadded(Space.EMPTY, (Object)new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, "class", (JavaType)parameterized, null), Markers.EMPTY), (JavaType)parameterized);
    }

    @Nullable
    private static JavaType.Class getClassType(@Nullable JavaType type) {
        if (type instanceof JavaType.Class) {
            JavaType.Class classType = (JavaType.Class)type;
            if (classType.getFullyQualifiedName().equals("java.lang.Class")) {
                return classType;
            }
            if (classType.getFullyQualifiedName().equals("java.lang.Object")) {
                for (JavaType.Method method : classType.getMethods()) {
                    if (!method.getName().equals("getClass")) continue;
                    return JavaElementFactory.getClassType(method.getReturnType());
                }
                return null;
            }
            return JavaElementFactory.getClassType((JavaType)classType.getSupertype());
        }
        if (type instanceof JavaType.Parameterized) {
            return JavaElementFactory.getClassType((JavaType)((JavaType.Parameterized)type).getType());
        }
        if (type instanceof JavaType.GenericTypeVariable) {
            return JavaElementFactory.getClassType((JavaType)((JavaType.GenericTypeVariable)type).getBounds().get(0));
        }
        if (type instanceof JavaType.Array) {
            return JavaElementFactory.getClassType(((JavaType.Array)type).getElemType());
        }
        if (type instanceof JavaType.Variable) {
            return JavaElementFactory.getClassType(((JavaType.Variable)type).getOwner());
        }
        if (type instanceof JavaType.Method) {
            return JavaElementFactory.getClassType((JavaType)((JavaType.Method)type).getDeclaringType());
        }
        return null;
    }
}

