/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.staticanalysis.EmptyBlock;

public class RemoveCallsToSystemGc
extends Recipe {
    private static final MethodMatcher SYSTEM_GC = new MethodMatcher("java.lang.System gc()");
    private static final MethodMatcher RUNTIME_GC = new MethodMatcher("java.lang.Runtime gc()");

    public String getDisplayName() {
        return "Remove garbage collection invocations";
    }

    public String getDescription() {
        return "Removes calls to `System.gc()` and `Runtime.gc()`. When to invoke garbage collection is best left to the JVM.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-1215");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(1L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod(SYSTEM_GC), new UsesMethod(RUNTIME_GC)}), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext context) {
                J.MethodInvocation invocation = super.visitMethodInvocation(method, (Object)context);
                if (SYSTEM_GC.matches(invocation) || RUNTIME_GC.matches(invocation)) {
                    this.doAfterVisit(new EmptyBlock().getVisitor());
                    return null;
                }
                return invocation;
            }
        });
    }
}

