/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;
import org.openrewrite.staticanalysis.EqualsAvoidsNull;

public class StringLiteralEquality
extends Recipe {
    public String getDisplayName() {
        return "Use `String.equals()` on String literals";
    }

    public String getDescription() {
        return "`String.equals()` should be used when checking value equality on String literals. Using `==` or `!=` compares object references, not the actual value of the Strings. This only modifies code where at least one side of the binary operation (`==` or `!=`) is a String literal, such as `\"someString\" == someVariable;`. This is to prevent inadvertently changing code where referential equality is the user's intent.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-4973");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType("java.lang.String", Boolean.valueOf(false)), (TreeVisitor)new JavaVisitor<ExecutionContext>(){
            private final JavaType.FullyQualified TYPE_STRING = TypeUtils.asFullyQualified((JavaType)JavaType.buildType((String)"java.lang.String"));
            private final JavaType TYPE_OBJECT = JavaType.buildType((String)"java.lang.Object");

            private boolean isStringLiteral(Expression expression) {
                return expression instanceof J.Literal && TypeUtils.isString((JavaType)((J.Literal)expression).getType());
            }

            private J.MethodInvocation asEqualsMethodInvocation(J.Binary binary) {
                return new J.MethodInvocation(Tree.randomId(), binary.getPrefix(), Markers.EMPTY, new JRightPadded((Object)((Expression)binary.getLeft().withPrefix(Space.EMPTY)), Space.EMPTY, Markers.EMPTY), null, new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, "equals", (JavaType)JavaType.Primitive.Boolean, null), JContainer.build(Collections.singletonList(new JRightPadded((Object)((Expression)binary.getRight().withPrefix(Space.EMPTY)), Space.EMPTY, Markers.EMPTY))), new JavaType.Method(null, Flag.Public.getBitMask(), this.TYPE_STRING, "equals", (JavaType)JavaType.Primitive.Boolean, Collections.singletonList("o"), Collections.singletonList(this.TYPE_OBJECT), null, null, null));
            }

            private J.Unary asNegatedUnary(J.MethodInvocation mi) {
                return new J.Unary(Tree.randomId(), Space.EMPTY, Markers.EMPTY, new JLeftPadded(Space.EMPTY, (Object)J.Unary.Type.Not, Markers.EMPTY), (Expression)mi, (JavaType)JavaType.Primitive.Boolean);
            }

            public J visitBinary(J.Binary binary, ExecutionContext ctx) {
                if (this.isStringLiteral(binary.getLeft()) || this.isStringLiteral(binary.getRight())) {
                    J.MethodInvocation after = null;
                    if (binary.getOperator() == J.Binary.Type.Equal) {
                        after = this.asEqualsMethodInvocation(binary);
                    } else if (binary.getOperator() == J.Binary.Type.NotEqual) {
                        J.MethodInvocation mi = this.asEqualsMethodInvocation(binary);
                        after = this.asNegatedUnary(mi);
                    }
                    if (after != null) {
                        this.doAfterVisit(new EqualsAvoidsNull().getVisitor());
                        return after;
                    }
                }
                return super.visitBinary(binary, (Object)ctx);
            }
        });
    }
}

