/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.prethink.table;

import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;

public class TestMapping
extends DataTable<Row> {
    public TestMapping(Recipe recipe) {
        super(recipe, "Test mapping", "Mapping of test methods to the implementation methods they test.");
    }

    public static final class Row {
        @Column(displayName="Test source path", description="The path to the test source file.")
        private final String testSourcePath;
        @Column(displayName="Test class", description="The fully qualified name of the test class.")
        private final String testClass;
        @Column(displayName="Test method", description="The signature of the test method.")
        private final String testMethod;
        @Column(displayName="Implementation source path", description="The path to the implementation source file being tested.")
        private final String implementationSourcePath;
        @Column(displayName="Implementation class", description="The fully qualified name of the implementation class being tested.")
        private final String implementationClass;
        @Column(displayName="Implementation method", description="The signature of the implementation method being tested.")
        private final String implementationMethod;
        @Column(displayName="Test summary", description="AI-generated summary of what the test is verifying.")
        private final @Nullable String testSummary;
        @Column(displayName="Test checksum", description="Hash of the test method code for cache invalidation.")
        private final @Nullable String testChecksum;

        @Generated
        public Row(String testSourcePath, String testClass, String testMethod, String implementationSourcePath, String implementationClass, String implementationMethod, @Nullable String testSummary, @Nullable String testChecksum) {
            this.testSourcePath = testSourcePath;
            this.testClass = testClass;
            this.testMethod = testMethod;
            this.implementationSourcePath = implementationSourcePath;
            this.implementationClass = implementationClass;
            this.implementationMethod = implementationMethod;
            this.testSummary = testSummary;
            this.testChecksum = testChecksum;
        }

        @Generated
        public String getTestSourcePath() {
            return this.testSourcePath;
        }

        @Generated
        public String getTestClass() {
            return this.testClass;
        }

        @Generated
        public String getTestMethod() {
            return this.testMethod;
        }

        @Generated
        public String getImplementationSourcePath() {
            return this.implementationSourcePath;
        }

        @Generated
        public String getImplementationClass() {
            return this.implementationClass;
        }

        @Generated
        public String getImplementationMethod() {
            return this.implementationMethod;
        }

        @Generated
        public @Nullable String getTestSummary() {
            return this.testSummary;
        }

        @Generated
        public @Nullable String getTestChecksum() {
            return this.testChecksum;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            String this$testSourcePath = this.getTestSourcePath();
            String other$testSourcePath = other.getTestSourcePath();
            if (this$testSourcePath == null ? other$testSourcePath != null : !this$testSourcePath.equals(other$testSourcePath)) {
                return false;
            }
            String this$testClass = this.getTestClass();
            String other$testClass = other.getTestClass();
            if (this$testClass == null ? other$testClass != null : !this$testClass.equals(other$testClass)) {
                return false;
            }
            String this$testMethod = this.getTestMethod();
            String other$testMethod = other.getTestMethod();
            if (this$testMethod == null ? other$testMethod != null : !this$testMethod.equals(other$testMethod)) {
                return false;
            }
            String this$implementationSourcePath = this.getImplementationSourcePath();
            String other$implementationSourcePath = other.getImplementationSourcePath();
            if (this$implementationSourcePath == null ? other$implementationSourcePath != null : !this$implementationSourcePath.equals(other$implementationSourcePath)) {
                return false;
            }
            String this$implementationClass = this.getImplementationClass();
            String other$implementationClass = other.getImplementationClass();
            if (this$implementationClass == null ? other$implementationClass != null : !this$implementationClass.equals(other$implementationClass)) {
                return false;
            }
            String this$implementationMethod = this.getImplementationMethod();
            String other$implementationMethod = other.getImplementationMethod();
            if (this$implementationMethod == null ? other$implementationMethod != null : !this$implementationMethod.equals(other$implementationMethod)) {
                return false;
            }
            String this$testSummary = this.getTestSummary();
            String other$testSummary = other.getTestSummary();
            if (this$testSummary == null ? other$testSummary != null : !this$testSummary.equals(other$testSummary)) {
                return false;
            }
            String this$testChecksum = this.getTestChecksum();
            String other$testChecksum = other.getTestChecksum();
            return !(this$testChecksum == null ? other$testChecksum != null : !this$testChecksum.equals(other$testChecksum));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $testSourcePath = this.getTestSourcePath();
            result = result * 59 + ($testSourcePath == null ? 43 : $testSourcePath.hashCode());
            String $testClass = this.getTestClass();
            result = result * 59 + ($testClass == null ? 43 : $testClass.hashCode());
            String $testMethod = this.getTestMethod();
            result = result * 59 + ($testMethod == null ? 43 : $testMethod.hashCode());
            String $implementationSourcePath = this.getImplementationSourcePath();
            result = result * 59 + ($implementationSourcePath == null ? 43 : $implementationSourcePath.hashCode());
            String $implementationClass = this.getImplementationClass();
            result = result * 59 + ($implementationClass == null ? 43 : $implementationClass.hashCode());
            String $implementationMethod = this.getImplementationMethod();
            result = result * 59 + ($implementationMethod == null ? 43 : $implementationMethod.hashCode());
            String $testSummary = this.getTestSummary();
            result = result * 59 + ($testSummary == null ? 43 : $testSummary.hashCode());
            String $testChecksum = this.getTestChecksum();
            result = result * 59 + ($testChecksum == null ? 43 : $testChecksum.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "TestMapping.Row(testSourcePath=" + this.getTestSourcePath() + ", testClass=" + this.getTestClass() + ", testMethod=" + this.getTestMethod() + ", implementationSourcePath=" + this.getImplementationSourcePath() + ", implementationClass=" + this.getImplementationClass() + ", implementationMethod=" + this.getImplementationMethod() + ", testSummary=" + this.getTestSummary() + ", testChecksum=" + this.getTestChecksum() + ")";
        }
    }
}

