/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.prethink.table;

import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;

public class ServiceEndpoints
extends DataTable<Row> {
    public ServiceEndpoints(Recipe recipe) {
        super(recipe, "Service endpoints", "REST/HTTP endpoints exposed by the application.");
    }

    public static final class Row {
        @Column(displayName="Source path", description="The path to the source file containing the endpoint.")
        private final String sourcePath;
        @Column(displayName="Service class", description="The fully qualified name of the controller or resource class.")
        private final String serviceClass;
        @Column(displayName="Service name", description="A human-readable name for the service derived from the class name.")
        private final String serviceName;
        @Column(displayName="Method name", description="The name of the endpoint method.")
        private final String methodName;
        @Column(displayName="HTTP method", description="The HTTP method (GET, POST, PUT, DELETE, PATCH, etc.).")
        private final String httpMethod;
        @Column(displayName="Path", description="The URL path pattern for the endpoint.")
        private final String path;
        @Column(displayName="Produces", description="Content types the endpoint produces (e.g., application/json).")
        private final @Nullable String produces;
        @Column(displayName="Consumes", description="Content types the endpoint consumes (e.g., application/json).")
        private final @Nullable String consumes;
        @Column(displayName="Framework", description="The web framework used (Spring, JAX-RS, Micronaut, Quarkus).")
        private final String framework;
        @Column(displayName="Method signature", description="The full method signature for linking to method descriptions.")
        private final @Nullable String methodSignature;

        @Generated
        public Row(String sourcePath, String serviceClass, String serviceName, String methodName, String httpMethod, String path, @Nullable String produces, @Nullable String consumes, String framework, @Nullable String methodSignature) {
            this.sourcePath = sourcePath;
            this.serviceClass = serviceClass;
            this.serviceName = serviceName;
            this.methodName = methodName;
            this.httpMethod = httpMethod;
            this.path = path;
            this.produces = produces;
            this.consumes = consumes;
            this.framework = framework;
            this.methodSignature = methodSignature;
        }

        @Generated
        public String getSourcePath() {
            return this.sourcePath;
        }

        @Generated
        public String getServiceClass() {
            return this.serviceClass;
        }

        @Generated
        public String getServiceName() {
            return this.serviceName;
        }

        @Generated
        public String getMethodName() {
            return this.methodName;
        }

        @Generated
        public String getHttpMethod() {
            return this.httpMethod;
        }

        @Generated
        public String getPath() {
            return this.path;
        }

        @Generated
        public @Nullable String getProduces() {
            return this.produces;
        }

        @Generated
        public @Nullable String getConsumes() {
            return this.consumes;
        }

        @Generated
        public String getFramework() {
            return this.framework;
        }

        @Generated
        public @Nullable String getMethodSignature() {
            return this.methodSignature;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            String this$sourcePath = this.getSourcePath();
            String other$sourcePath = other.getSourcePath();
            if (this$sourcePath == null ? other$sourcePath != null : !this$sourcePath.equals(other$sourcePath)) {
                return false;
            }
            String this$serviceClass = this.getServiceClass();
            String other$serviceClass = other.getServiceClass();
            if (this$serviceClass == null ? other$serviceClass != null : !this$serviceClass.equals(other$serviceClass)) {
                return false;
            }
            String this$serviceName = this.getServiceName();
            String other$serviceName = other.getServiceName();
            if (this$serviceName == null ? other$serviceName != null : !this$serviceName.equals(other$serviceName)) {
                return false;
            }
            String this$methodName = this.getMethodName();
            String other$methodName = other.getMethodName();
            if (this$methodName == null ? other$methodName != null : !this$methodName.equals(other$methodName)) {
                return false;
            }
            String this$httpMethod = this.getHttpMethod();
            String other$httpMethod = other.getHttpMethod();
            if (this$httpMethod == null ? other$httpMethod != null : !this$httpMethod.equals(other$httpMethod)) {
                return false;
            }
            String this$path = this.getPath();
            String other$path = other.getPath();
            if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
                return false;
            }
            String this$produces = this.getProduces();
            String other$produces = other.getProduces();
            if (this$produces == null ? other$produces != null : !this$produces.equals(other$produces)) {
                return false;
            }
            String this$consumes = this.getConsumes();
            String other$consumes = other.getConsumes();
            if (this$consumes == null ? other$consumes != null : !this$consumes.equals(other$consumes)) {
                return false;
            }
            String this$framework = this.getFramework();
            String other$framework = other.getFramework();
            if (this$framework == null ? other$framework != null : !this$framework.equals(other$framework)) {
                return false;
            }
            String this$methodSignature = this.getMethodSignature();
            String other$methodSignature = other.getMethodSignature();
            return !(this$methodSignature == null ? other$methodSignature != null : !this$methodSignature.equals(other$methodSignature));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $sourcePath = this.getSourcePath();
            result = result * 59 + ($sourcePath == null ? 43 : $sourcePath.hashCode());
            String $serviceClass = this.getServiceClass();
            result = result * 59 + ($serviceClass == null ? 43 : $serviceClass.hashCode());
            String $serviceName = this.getServiceName();
            result = result * 59 + ($serviceName == null ? 43 : $serviceName.hashCode());
            String $methodName = this.getMethodName();
            result = result * 59 + ($methodName == null ? 43 : $methodName.hashCode());
            String $httpMethod = this.getHttpMethod();
            result = result * 59 + ($httpMethod == null ? 43 : $httpMethod.hashCode());
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            String $produces = this.getProduces();
            result = result * 59 + ($produces == null ? 43 : $produces.hashCode());
            String $consumes = this.getConsumes();
            result = result * 59 + ($consumes == null ? 43 : $consumes.hashCode());
            String $framework = this.getFramework();
            result = result * 59 + ($framework == null ? 43 : $framework.hashCode());
            String $methodSignature = this.getMethodSignature();
            result = result * 59 + ($methodSignature == null ? 43 : $methodSignature.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ServiceEndpoints.Row(sourcePath=" + this.getSourcePath() + ", serviceClass=" + this.getServiceClass() + ", serviceName=" + this.getServiceName() + ", methodName=" + this.getMethodName() + ", httpMethod=" + this.getHttpMethod() + ", path=" + this.getPath() + ", produces=" + this.getProduces() + ", consumes=" + this.getConsumes() + ", framework=" + this.getFramework() + ", methodSignature=" + this.getMethodSignature() + ")";
        }
    }
}

