/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.prethink.table;

import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;

public class ServerConfiguration
extends DataTable<Row> {
    public ServerConfiguration(Recipe recipe) {
        super(recipe, "Server configuration", "Server configuration properties extracted from application.properties/yml.");
    }

    public static final class Row {
        @Column(displayName="Source path", description="The path to the configuration file.")
        private final String sourcePath;
        @Column(displayName="Server port", description="The server port (default: 8080).")
        private final int port;
        @Column(displayName="SSL enabled", description="Whether SSL/TLS is enabled.")
        private final boolean sslEnabled;
        @Column(displayName="Context path", description="The servlet context path.")
        private final @Nullable String contextPath;
        @Column(displayName="Protocol", description="The protocol (HTTP or HTTPS) based on SSL configuration.")
        private final String protocol;

        @Generated
        public Row(String sourcePath, int port, boolean sslEnabled, @Nullable String contextPath, String protocol) {
            this.sourcePath = sourcePath;
            this.port = port;
            this.sslEnabled = sslEnabled;
            this.contextPath = contextPath;
            this.protocol = protocol;
        }

        @Generated
        public String getSourcePath() {
            return this.sourcePath;
        }

        @Generated
        public int getPort() {
            return this.port;
        }

        @Generated
        public boolean isSslEnabled() {
            return this.sslEnabled;
        }

        @Generated
        public @Nullable String getContextPath() {
            return this.contextPath;
        }

        @Generated
        public String getProtocol() {
            return this.protocol;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            if (this.getPort() != other.getPort()) {
                return false;
            }
            if (this.isSslEnabled() != other.isSslEnabled()) {
                return false;
            }
            String this$sourcePath = this.getSourcePath();
            String other$sourcePath = other.getSourcePath();
            if (this$sourcePath == null ? other$sourcePath != null : !this$sourcePath.equals(other$sourcePath)) {
                return false;
            }
            String this$contextPath = this.getContextPath();
            String other$contextPath = other.getContextPath();
            if (this$contextPath == null ? other$contextPath != null : !this$contextPath.equals(other$contextPath)) {
                return false;
            }
            String this$protocol = this.getProtocol();
            String other$protocol = other.getProtocol();
            return !(this$protocol == null ? other$protocol != null : !this$protocol.equals(other$protocol));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getPort();
            result = result * 59 + (this.isSslEnabled() ? 79 : 97);
            String $sourcePath = this.getSourcePath();
            result = result * 59 + ($sourcePath == null ? 43 : $sourcePath.hashCode());
            String $contextPath = this.getContextPath();
            result = result * 59 + ($contextPath == null ? 43 : $contextPath.hashCode());
            String $protocol = this.getProtocol();
            result = result * 59 + ($protocol == null ? 43 : $protocol.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ServerConfiguration.Row(sourcePath=" + this.getSourcePath() + ", port=" + this.getPort() + ", sslEnabled=" + this.isSslEnabled() + ", contextPath=" + this.getContextPath() + ", protocol=" + this.getProtocol() + ")";
        }
    }
}

