/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.prethink.table;

import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;

public class SecurityConfiguration
extends DataTable<Row> {
    public SecurityConfiguration(Recipe recipe) {
        super(recipe, "Security configuration", "Security configuration including authentication methods, CORS settings, and OAuth2 configuration.");
    }

    public static final class Row {
        @Column(displayName="Source path", description="The path to the source file containing the security configuration.")
        private final String sourcePath;
        @Column(displayName="Configuration type", description="The type of security configuration (WebSecurity, OAuth2, CORS, etc.).")
        private final String configurationType;
        @Column(displayName="Auth method", description="Authentication method if detected (Basic, OAuth2, JWT, etc.).")
        private final @Nullable String authMethod;
        @Column(displayName="Allowed origins", description="CORS allowed origins if configured.")
        private final @Nullable String allowedOrigins;
        @Column(displayName="Description", description="Description of the security configuration.")
        private final @Nullable String description;

        @Generated
        public Row(String sourcePath, String configurationType, @Nullable String authMethod, @Nullable String allowedOrigins, @Nullable String description) {
            this.sourcePath = sourcePath;
            this.configurationType = configurationType;
            this.authMethod = authMethod;
            this.allowedOrigins = allowedOrigins;
            this.description = description;
        }

        @Generated
        public String getSourcePath() {
            return this.sourcePath;
        }

        @Generated
        public String getConfigurationType() {
            return this.configurationType;
        }

        @Generated
        public @Nullable String getAuthMethod() {
            return this.authMethod;
        }

        @Generated
        public @Nullable String getAllowedOrigins() {
            return this.allowedOrigins;
        }

        @Generated
        public @Nullable String getDescription() {
            return this.description;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            String this$sourcePath = this.getSourcePath();
            String other$sourcePath = other.getSourcePath();
            if (this$sourcePath == null ? other$sourcePath != null : !this$sourcePath.equals(other$sourcePath)) {
                return false;
            }
            String this$configurationType = this.getConfigurationType();
            String other$configurationType = other.getConfigurationType();
            if (this$configurationType == null ? other$configurationType != null : !this$configurationType.equals(other$configurationType)) {
                return false;
            }
            String this$authMethod = this.getAuthMethod();
            String other$authMethod = other.getAuthMethod();
            if (this$authMethod == null ? other$authMethod != null : !this$authMethod.equals(other$authMethod)) {
                return false;
            }
            String this$allowedOrigins = this.getAllowedOrigins();
            String other$allowedOrigins = other.getAllowedOrigins();
            if (this$allowedOrigins == null ? other$allowedOrigins != null : !this$allowedOrigins.equals(other$allowedOrigins)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            return !(this$description == null ? other$description != null : !this$description.equals(other$description));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $sourcePath = this.getSourcePath();
            result = result * 59 + ($sourcePath == null ? 43 : $sourcePath.hashCode());
            String $configurationType = this.getConfigurationType();
            result = result * 59 + ($configurationType == null ? 43 : $configurationType.hashCode());
            String $authMethod = this.getAuthMethod();
            result = result * 59 + ($authMethod == null ? 43 : $authMethod.hashCode());
            String $allowedOrigins = this.getAllowedOrigins();
            result = result * 59 + ($allowedOrigins == null ? 43 : $allowedOrigins.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SecurityConfiguration.Row(sourcePath=" + this.getSourcePath() + ", configurationType=" + this.getConfigurationType() + ", authMethod=" + this.getAuthMethod() + ", allowedOrigins=" + this.getAllowedOrigins() + ", description=" + this.getDescription() + ")";
        }
    }
}

