/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.prethink.table;

import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;

public class MethodDescriptions
extends DataTable<Row> {
    public MethodDescriptions(Recipe recipe) {
        super(recipe, "Method descriptions", "AI-generated descriptions of methods in the codebase.");
    }

    public static final class Row {
        @Column(displayName="Source path", description="The path to the source file containing the method.")
        private final String sourcePath;
        @Column(displayName="Class name", description="The fully qualified name of the class containing the method.")
        private final String className;
        @Column(displayName="Signature", description="The method signature.")
        private final String signature;
        @Column(displayName="Checksum", description="SHA-256 checksum of the method source text for incremental updates.")
        private final String checksum;
        @Column(displayName="Description", description="AI-generated description of what the method does.")
        private final String description;
        @Column(displayName="Return value description", description="AI-generated description of what the method returns.")
        private final @Nullable String returnValueDescription;
        @Column(displayName="Technique 1", description="First technique or library used by this method.")
        private final @Nullable String technique1;
        @Column(displayName="Technique 2", description="Second technique or library used by this method.")
        private final @Nullable String technique2;
        @Column(displayName="Technique 3", description="Third technique or library used by this method.")
        private final @Nullable String technique3;
        @Column(displayName="Inference time (ms)", description="Time taken to generate the description in milliseconds.")
        private final long inferenceTimeMs;

        @Generated
        public Row(String sourcePath, String className, String signature, String checksum, String description, @Nullable String returnValueDescription, @Nullable String technique1, @Nullable String technique2, @Nullable String technique3, long inferenceTimeMs) {
            this.sourcePath = sourcePath;
            this.className = className;
            this.signature = signature;
            this.checksum = checksum;
            this.description = description;
            this.returnValueDescription = returnValueDescription;
            this.technique1 = technique1;
            this.technique2 = technique2;
            this.technique3 = technique3;
            this.inferenceTimeMs = inferenceTimeMs;
        }

        @Generated
        public String getSourcePath() {
            return this.sourcePath;
        }

        @Generated
        public String getClassName() {
            return this.className;
        }

        @Generated
        public String getSignature() {
            return this.signature;
        }

        @Generated
        public String getChecksum() {
            return this.checksum;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public @Nullable String getReturnValueDescription() {
            return this.returnValueDescription;
        }

        @Generated
        public @Nullable String getTechnique1() {
            return this.technique1;
        }

        @Generated
        public @Nullable String getTechnique2() {
            return this.technique2;
        }

        @Generated
        public @Nullable String getTechnique3() {
            return this.technique3;
        }

        @Generated
        public long getInferenceTimeMs() {
            return this.inferenceTimeMs;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            if (this.getInferenceTimeMs() != other.getInferenceTimeMs()) {
                return false;
            }
            String this$sourcePath = this.getSourcePath();
            String other$sourcePath = other.getSourcePath();
            if (this$sourcePath == null ? other$sourcePath != null : !this$sourcePath.equals(other$sourcePath)) {
                return false;
            }
            String this$className = this.getClassName();
            String other$className = other.getClassName();
            if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
                return false;
            }
            String this$signature = this.getSignature();
            String other$signature = other.getSignature();
            if (this$signature == null ? other$signature != null : !this$signature.equals(other$signature)) {
                return false;
            }
            String this$checksum = this.getChecksum();
            String other$checksum = other.getChecksum();
            if (this$checksum == null ? other$checksum != null : !this$checksum.equals(other$checksum)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            String this$returnValueDescription = this.getReturnValueDescription();
            String other$returnValueDescription = other.getReturnValueDescription();
            if (this$returnValueDescription == null ? other$returnValueDescription != null : !this$returnValueDescription.equals(other$returnValueDescription)) {
                return false;
            }
            String this$technique1 = this.getTechnique1();
            String other$technique1 = other.getTechnique1();
            if (this$technique1 == null ? other$technique1 != null : !this$technique1.equals(other$technique1)) {
                return false;
            }
            String this$technique2 = this.getTechnique2();
            String other$technique2 = other.getTechnique2();
            if (this$technique2 == null ? other$technique2 != null : !this$technique2.equals(other$technique2)) {
                return false;
            }
            String this$technique3 = this.getTechnique3();
            String other$technique3 = other.getTechnique3();
            return !(this$technique3 == null ? other$technique3 != null : !this$technique3.equals(other$technique3));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $inferenceTimeMs = this.getInferenceTimeMs();
            result = result * 59 + (int)($inferenceTimeMs >>> 32 ^ $inferenceTimeMs);
            String $sourcePath = this.getSourcePath();
            result = result * 59 + ($sourcePath == null ? 43 : $sourcePath.hashCode());
            String $className = this.getClassName();
            result = result * 59 + ($className == null ? 43 : $className.hashCode());
            String $signature = this.getSignature();
            result = result * 59 + ($signature == null ? 43 : $signature.hashCode());
            String $checksum = this.getChecksum();
            result = result * 59 + ($checksum == null ? 43 : $checksum.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            String $returnValueDescription = this.getReturnValueDescription();
            result = result * 59 + ($returnValueDescription == null ? 43 : $returnValueDescription.hashCode());
            String $technique1 = this.getTechnique1();
            result = result * 59 + ($technique1 == null ? 43 : $technique1.hashCode());
            String $technique2 = this.getTechnique2();
            result = result * 59 + ($technique2 == null ? 43 : $technique2.hashCode());
            String $technique3 = this.getTechnique3();
            result = result * 59 + ($technique3 == null ? 43 : $technique3.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "MethodDescriptions.Row(sourcePath=" + this.getSourcePath() + ", className=" + this.getClassName() + ", signature=" + this.getSignature() + ", checksum=" + this.getChecksum() + ", description=" + this.getDescription() + ", returnValueDescription=" + this.getReturnValueDescription() + ", technique1=" + this.getTechnique1() + ", technique2=" + this.getTechnique2() + ", technique3=" + this.getTechnique3() + ", inferenceTimeMs=" + this.getInferenceTimeMs() + ")";
        }
    }
}

