/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.prethink.table;

import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;

public class MessagingConnections
extends DataTable<Row> {
    public MessagingConnections(Recipe recipe) {
        super(recipe, "Messaging connections", "Message queue producers and consumers in the application.");
    }

    public static final class Row {
        @Column(displayName="Source path", description="The path to the source file containing the messaging component.")
        private final String sourcePath;
        @Column(displayName="Class name", description="The fully qualified name of the class containing the listener/producer.")
        private final String className;
        @Column(displayName="Method name", description="The name of the method that handles or sends messages.")
        private final @Nullable String methodName;
        @Column(displayName="Destination", description="The topic or queue name.")
        private final String destination;
        @Column(displayName="Role", description="Whether this is a producer, consumer, or both.")
        private final String role;
        @Column(displayName="Messaging type", description="The messaging system (Kafka, RabbitMQ, JMS, etc.).")
        private final String messagingType;
        @Column(displayName="Method signature", description="The full method signature for linking to method descriptions.")
        private final @Nullable String methodSignature;

        @Generated
        public Row(String sourcePath, String className, @Nullable String methodName, String destination, String role, String messagingType, @Nullable String methodSignature) {
            this.sourcePath = sourcePath;
            this.className = className;
            this.methodName = methodName;
            this.destination = destination;
            this.role = role;
            this.messagingType = messagingType;
            this.methodSignature = methodSignature;
        }

        @Generated
        public String getSourcePath() {
            return this.sourcePath;
        }

        @Generated
        public String getClassName() {
            return this.className;
        }

        @Generated
        public @Nullable String getMethodName() {
            return this.methodName;
        }

        @Generated
        public String getDestination() {
            return this.destination;
        }

        @Generated
        public String getRole() {
            return this.role;
        }

        @Generated
        public String getMessagingType() {
            return this.messagingType;
        }

        @Generated
        public @Nullable String getMethodSignature() {
            return this.methodSignature;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            String this$sourcePath = this.getSourcePath();
            String other$sourcePath = other.getSourcePath();
            if (this$sourcePath == null ? other$sourcePath != null : !this$sourcePath.equals(other$sourcePath)) {
                return false;
            }
            String this$className = this.getClassName();
            String other$className = other.getClassName();
            if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
                return false;
            }
            String this$methodName = this.getMethodName();
            String other$methodName = other.getMethodName();
            if (this$methodName == null ? other$methodName != null : !this$methodName.equals(other$methodName)) {
                return false;
            }
            String this$destination = this.getDestination();
            String other$destination = other.getDestination();
            if (this$destination == null ? other$destination != null : !this$destination.equals(other$destination)) {
                return false;
            }
            String this$role = this.getRole();
            String other$role = other.getRole();
            if (this$role == null ? other$role != null : !this$role.equals(other$role)) {
                return false;
            }
            String this$messagingType = this.getMessagingType();
            String other$messagingType = other.getMessagingType();
            if (this$messagingType == null ? other$messagingType != null : !this$messagingType.equals(other$messagingType)) {
                return false;
            }
            String this$methodSignature = this.getMethodSignature();
            String other$methodSignature = other.getMethodSignature();
            return !(this$methodSignature == null ? other$methodSignature != null : !this$methodSignature.equals(other$methodSignature));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $sourcePath = this.getSourcePath();
            result = result * 59 + ($sourcePath == null ? 43 : $sourcePath.hashCode());
            String $className = this.getClassName();
            result = result * 59 + ($className == null ? 43 : $className.hashCode());
            String $methodName = this.getMethodName();
            result = result * 59 + ($methodName == null ? 43 : $methodName.hashCode());
            String $destination = this.getDestination();
            result = result * 59 + ($destination == null ? 43 : $destination.hashCode());
            String $role = this.getRole();
            result = result * 59 + ($role == null ? 43 : $role.hashCode());
            String $messagingType = this.getMessagingType();
            result = result * 59 + ($messagingType == null ? 43 : $messagingType.hashCode());
            String $methodSignature = this.getMethodSignature();
            result = result * 59 + ($methodSignature == null ? 43 : $methodSignature.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "MessagingConnections.Row(sourcePath=" + this.getSourcePath() + ", className=" + this.getClassName() + ", methodName=" + this.getMethodName() + ", destination=" + this.getDestination() + ", role=" + this.getRole() + ", messagingType=" + this.getMessagingType() + ", methodSignature=" + this.getMethodSignature() + ")";
        }
    }
}

