/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.prethink.table;

import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;

public class ExternalServiceCalls
extends DataTable<Row> {
    public ExternalServiceCalls(Recipe recipe) {
        super(recipe, "External service calls", "Outbound HTTP/REST calls to external services.");
    }

    public static final class Row {
        @Column(displayName="Source path", description="The path to the source file containing the external service call.")
        private final String sourcePath;
        @Column(displayName="Client class", description="The fully qualified name of the class making the external call.")
        private final String clientClass;
        @Column(displayName="Target service", description="The name or URL of the target external service.")
        private final String targetService;
        @Column(displayName="Client type", description="The type of HTTP client used (RestTemplate, WebClient, Feign, etc.).")
        private final String clientType;
        @Column(displayName="Protocol", description="The protocol used (HTTP, HTTPS).")
        private final @Nullable String protocol;
        @Column(displayName="Base URL", description="The base URL for the external service if configured.")
        private final @Nullable String baseUrl;

        @Generated
        public Row(String sourcePath, String clientClass, String targetService, String clientType, @Nullable String protocol, @Nullable String baseUrl) {
            this.sourcePath = sourcePath;
            this.clientClass = clientClass;
            this.targetService = targetService;
            this.clientType = clientType;
            this.protocol = protocol;
            this.baseUrl = baseUrl;
        }

        @Generated
        public String getSourcePath() {
            return this.sourcePath;
        }

        @Generated
        public String getClientClass() {
            return this.clientClass;
        }

        @Generated
        public String getTargetService() {
            return this.targetService;
        }

        @Generated
        public String getClientType() {
            return this.clientType;
        }

        @Generated
        public @Nullable String getProtocol() {
            return this.protocol;
        }

        @Generated
        public @Nullable String getBaseUrl() {
            return this.baseUrl;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            String this$sourcePath = this.getSourcePath();
            String other$sourcePath = other.getSourcePath();
            if (this$sourcePath == null ? other$sourcePath != null : !this$sourcePath.equals(other$sourcePath)) {
                return false;
            }
            String this$clientClass = this.getClientClass();
            String other$clientClass = other.getClientClass();
            if (this$clientClass == null ? other$clientClass != null : !this$clientClass.equals(other$clientClass)) {
                return false;
            }
            String this$targetService = this.getTargetService();
            String other$targetService = other.getTargetService();
            if (this$targetService == null ? other$targetService != null : !this$targetService.equals(other$targetService)) {
                return false;
            }
            String this$clientType = this.getClientType();
            String other$clientType = other.getClientType();
            if (this$clientType == null ? other$clientType != null : !this$clientType.equals(other$clientType)) {
                return false;
            }
            String this$protocol = this.getProtocol();
            String other$protocol = other.getProtocol();
            if (this$protocol == null ? other$protocol != null : !this$protocol.equals(other$protocol)) {
                return false;
            }
            String this$baseUrl = this.getBaseUrl();
            String other$baseUrl = other.getBaseUrl();
            return !(this$baseUrl == null ? other$baseUrl != null : !this$baseUrl.equals(other$baseUrl));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $sourcePath = this.getSourcePath();
            result = result * 59 + ($sourcePath == null ? 43 : $sourcePath.hashCode());
            String $clientClass = this.getClientClass();
            result = result * 59 + ($clientClass == null ? 43 : $clientClass.hashCode());
            String $targetService = this.getTargetService();
            result = result * 59 + ($targetService == null ? 43 : $targetService.hashCode());
            String $clientType = this.getClientType();
            result = result * 59 + ($clientType == null ? 43 : $clientType.hashCode());
            String $protocol = this.getProtocol();
            result = result * 59 + ($protocol == null ? 43 : $protocol.hashCode());
            String $baseUrl = this.getBaseUrl();
            result = result * 59 + ($baseUrl == null ? 43 : $baseUrl.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ExternalServiceCalls.Row(sourcePath=" + this.getSourcePath() + ", clientClass=" + this.getClientClass() + ", targetService=" + this.getTargetService() + ", clientType=" + this.getClientType() + ", protocol=" + this.getProtocol() + ", baseUrl=" + this.getBaseUrl() + ")";
        }
    }
}

