/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.prethink.table;

import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;

public class DeploymentArtifacts
extends DataTable<Row> {
    public DeploymentArtifacts(Recipe recipe) {
        super(recipe, "Deployment artifacts", "Deployment configuration files (Dockerfile, Kubernetes manifests, docker-compose).");
    }

    public static final class Row {
        @Column(displayName="Source path", description="The path to the deployment artifact file.")
        private final String sourcePath;
        @Column(displayName="Artifact type", description="The type of deployment artifact (Dockerfile, Kubernetes, docker-compose).")
        private final String artifactType;
        @Column(displayName="Container image", description="The base container image if detected.")
        private final @Nullable String containerImage;
        @Column(displayName="Exposed port", description="Port exposed by the container.")
        private final @Nullable Integer exposedPort;
        @Column(displayName="Description", description="Description of the deployment artifact.")
        private final @Nullable String description;

        @Generated
        public Row(String sourcePath, String artifactType, @Nullable String containerImage, @Nullable Integer exposedPort, @Nullable String description) {
            this.sourcePath = sourcePath;
            this.artifactType = artifactType;
            this.containerImage = containerImage;
            this.exposedPort = exposedPort;
            this.description = description;
        }

        @Generated
        public String getSourcePath() {
            return this.sourcePath;
        }

        @Generated
        public String getArtifactType() {
            return this.artifactType;
        }

        @Generated
        public @Nullable String getContainerImage() {
            return this.containerImage;
        }

        @Generated
        public @Nullable Integer getExposedPort() {
            return this.exposedPort;
        }

        @Generated
        public @Nullable String getDescription() {
            return this.description;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            Integer this$exposedPort = this.getExposedPort();
            Integer other$exposedPort = other.getExposedPort();
            if (this$exposedPort == null ? other$exposedPort != null : !((Object)this$exposedPort).equals(other$exposedPort)) {
                return false;
            }
            String this$sourcePath = this.getSourcePath();
            String other$sourcePath = other.getSourcePath();
            if (this$sourcePath == null ? other$sourcePath != null : !this$sourcePath.equals(other$sourcePath)) {
                return false;
            }
            String this$artifactType = this.getArtifactType();
            String other$artifactType = other.getArtifactType();
            if (this$artifactType == null ? other$artifactType != null : !this$artifactType.equals(other$artifactType)) {
                return false;
            }
            String this$containerImage = this.getContainerImage();
            String other$containerImage = other.getContainerImage();
            if (this$containerImage == null ? other$containerImage != null : !this$containerImage.equals(other$containerImage)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            return !(this$description == null ? other$description != null : !this$description.equals(other$description));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $exposedPort = this.getExposedPort();
            result = result * 59 + ($exposedPort == null ? 43 : ((Object)$exposedPort).hashCode());
            String $sourcePath = this.getSourcePath();
            result = result * 59 + ($sourcePath == null ? 43 : $sourcePath.hashCode());
            String $artifactType = this.getArtifactType();
            result = result * 59 + ($artifactType == null ? 43 : $artifactType.hashCode());
            String $containerImage = this.getContainerImage();
            result = result * 59 + ($containerImage == null ? 43 : $containerImage.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "DeploymentArtifacts.Row(sourcePath=" + this.getSourcePath() + ", artifactType=" + this.getArtifactType() + ", containerImage=" + this.getContainerImage() + ", exposedPort=" + this.getExposedPort() + ", description=" + this.getDescription() + ")";
        }
    }
}

