/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.prethink.table;

import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;

public class DatabaseConnections
extends DataTable<Row> {
    public DatabaseConnections(Recipe recipe) {
        super(recipe, "Database connections", "Database connections and data access patterns in the application.");
    }

    public static final class Row {
        @Column(displayName="Source path", description="The path to the source file containing the database access.")
        private final String sourcePath;
        @Column(displayName="Entity/Table name", description="The name of the entity or table being accessed.")
        private final String entityName;
        @Column(displayName="Entity class", description="The fully qualified name of the entity class (if applicable).")
        private final @Nullable String entityClass;
        @Column(displayName="Repository class", description="The fully qualified name of the repository or DAO class (if applicable).")
        private final @Nullable String repositoryClass;
        @Column(displayName="Connection type", description="The type of database connection (JPA, JDBC, Spring Data, MyBatis).")
        private final String connectionType;
        @Column(displayName="Database type", description="The type of database if detectable (PostgreSQL, MySQL, MongoDB, etc.).")
        private final @Nullable String databaseType;

        @Generated
        public Row(String sourcePath, String entityName, @Nullable String entityClass, @Nullable String repositoryClass, String connectionType, @Nullable String databaseType) {
            this.sourcePath = sourcePath;
            this.entityName = entityName;
            this.entityClass = entityClass;
            this.repositoryClass = repositoryClass;
            this.connectionType = connectionType;
            this.databaseType = databaseType;
        }

        @Generated
        public String getSourcePath() {
            return this.sourcePath;
        }

        @Generated
        public String getEntityName() {
            return this.entityName;
        }

        @Generated
        public @Nullable String getEntityClass() {
            return this.entityClass;
        }

        @Generated
        public @Nullable String getRepositoryClass() {
            return this.repositoryClass;
        }

        @Generated
        public String getConnectionType() {
            return this.connectionType;
        }

        @Generated
        public @Nullable String getDatabaseType() {
            return this.databaseType;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            String this$sourcePath = this.getSourcePath();
            String other$sourcePath = other.getSourcePath();
            if (this$sourcePath == null ? other$sourcePath != null : !this$sourcePath.equals(other$sourcePath)) {
                return false;
            }
            String this$entityName = this.getEntityName();
            String other$entityName = other.getEntityName();
            if (this$entityName == null ? other$entityName != null : !this$entityName.equals(other$entityName)) {
                return false;
            }
            String this$entityClass = this.getEntityClass();
            String other$entityClass = other.getEntityClass();
            if (this$entityClass == null ? other$entityClass != null : !this$entityClass.equals(other$entityClass)) {
                return false;
            }
            String this$repositoryClass = this.getRepositoryClass();
            String other$repositoryClass = other.getRepositoryClass();
            if (this$repositoryClass == null ? other$repositoryClass != null : !this$repositoryClass.equals(other$repositoryClass)) {
                return false;
            }
            String this$connectionType = this.getConnectionType();
            String other$connectionType = other.getConnectionType();
            if (this$connectionType == null ? other$connectionType != null : !this$connectionType.equals(other$connectionType)) {
                return false;
            }
            String this$databaseType = this.getDatabaseType();
            String other$databaseType = other.getDatabaseType();
            return !(this$databaseType == null ? other$databaseType != null : !this$databaseType.equals(other$databaseType));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $sourcePath = this.getSourcePath();
            result = result * 59 + ($sourcePath == null ? 43 : $sourcePath.hashCode());
            String $entityName = this.getEntityName();
            result = result * 59 + ($entityName == null ? 43 : $entityName.hashCode());
            String $entityClass = this.getEntityClass();
            result = result * 59 + ($entityClass == null ? 43 : $entityClass.hashCode());
            String $repositoryClass = this.getRepositoryClass();
            result = result * 59 + ($repositoryClass == null ? 43 : $repositoryClass.hashCode());
            String $connectionType = this.getConnectionType();
            result = result * 59 + ($connectionType == null ? 43 : $connectionType.hashCode());
            String $databaseType = this.getDatabaseType();
            result = result * 59 + ($databaseType == null ? 43 : $databaseType.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "DatabaseConnections.Row(sourcePath=" + this.getSourcePath() + ", entityName=" + this.getEntityName() + ", entityClass=" + this.getEntityClass() + ", repositoryClass=" + this.getRepositoryClass() + ", connectionType=" + this.getConnectionType() + ", databaseType=" + this.getDatabaseType() + ")";
        }
    }
}

