/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.prethink.table;

import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;

public class DataAssets
extends DataTable<Row> {
    public DataAssets(Recipe recipe) {
        super(recipe, "Data assets", "Data entities, DTOs, and records that represent the application's data model.");
    }

    public static final class Row {
        @Column(displayName="Source path", description="The path to the source file containing the data asset.")
        private final String sourcePath;
        @Column(displayName="Class name", description="The fully qualified name of the data asset class.")
        private final String className;
        @Column(displayName="Simple name", description="The simple class name for display.")
        private final String simpleName;
        @Column(displayName="Asset type", description="The type of data asset (Entity, Record, DTO, Document, etc.).")
        private final String assetType;
        @Column(displayName="Description", description="A description of the data asset based on its fields.")
        private final @Nullable String description;
        @Column(displayName="Fields", description="Comma-separated list of field names.")
        private final @Nullable String fields;

        @Generated
        public Row(String sourcePath, String className, String simpleName, String assetType, @Nullable String description, @Nullable String fields) {
            this.sourcePath = sourcePath;
            this.className = className;
            this.simpleName = simpleName;
            this.assetType = assetType;
            this.description = description;
            this.fields = fields;
        }

        @Generated
        public String getSourcePath() {
            return this.sourcePath;
        }

        @Generated
        public String getClassName() {
            return this.className;
        }

        @Generated
        public String getSimpleName() {
            return this.simpleName;
        }

        @Generated
        public String getAssetType() {
            return this.assetType;
        }

        @Generated
        public @Nullable String getDescription() {
            return this.description;
        }

        @Generated
        public @Nullable String getFields() {
            return this.fields;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            String this$sourcePath = this.getSourcePath();
            String other$sourcePath = other.getSourcePath();
            if (this$sourcePath == null ? other$sourcePath != null : !this$sourcePath.equals(other$sourcePath)) {
                return false;
            }
            String this$className = this.getClassName();
            String other$className = other.getClassName();
            if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
                return false;
            }
            String this$simpleName = this.getSimpleName();
            String other$simpleName = other.getSimpleName();
            if (this$simpleName == null ? other$simpleName != null : !this$simpleName.equals(other$simpleName)) {
                return false;
            }
            String this$assetType = this.getAssetType();
            String other$assetType = other.getAssetType();
            if (this$assetType == null ? other$assetType != null : !this$assetType.equals(other$assetType)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            String this$fields = this.getFields();
            String other$fields = other.getFields();
            return !(this$fields == null ? other$fields != null : !this$fields.equals(other$fields));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $sourcePath = this.getSourcePath();
            result = result * 59 + ($sourcePath == null ? 43 : $sourcePath.hashCode());
            String $className = this.getClassName();
            result = result * 59 + ($className == null ? 43 : $className.hashCode());
            String $simpleName = this.getSimpleName();
            result = result * 59 + ($simpleName == null ? 43 : $simpleName.hashCode());
            String $assetType = this.getAssetType();
            result = result * 59 + ($assetType == null ? 43 : $assetType.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            String $fields = this.getFields();
            result = result * 59 + ($fields == null ? 43 : $fields.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "DataAssets.Row(sourcePath=" + this.getSourcePath() + ", className=" + this.getClassName() + ", simpleName=" + this.getSimpleName() + ", assetType=" + this.getAssetType() + ", description=" + this.getDescription() + ", fields=" + this.getFields() + ")";
        }
    }
}

