/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.prethink.table;

import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;

public class ClassDescriptions
extends DataTable<Row> {
    public ClassDescriptions(Recipe recipe) {
        super(recipe, "Class descriptions", "AI-generated descriptions of classes in the codebase.");
    }

    public static final class Row {
        @Column(displayName="Source path", description="The path to the source file containing the class.")
        private final String sourcePath;
        @Column(displayName="Class name", description="The fully qualified name of the class.")
        private final String className;
        @Column(displayName="Checksum", description="SHA-256 checksum of the class source text for incremental updates.")
        private final String checksum;
        @Column(displayName="Description", description="AI-generated description of what the class does.")
        private final String description;
        @Column(displayName="Responsibility", description="The primary responsibility or purpose of the class (2-3 words).")
        private final String responsibility;
        @Column(displayName="Pattern 1", description="First architectural pattern used by this class.")
        private final @Nullable String pattern1;
        @Column(displayName="Pattern 2", description="Second architectural pattern used by this class.")
        private final @Nullable String pattern2;
        @Column(displayName="Pattern 3", description="Third architectural pattern used by this class.")
        private final @Nullable String pattern3;
        @Column(displayName="Inference time (ms)", description="Time taken to generate the description in milliseconds.")
        private final long inferenceTimeMs;

        @Generated
        public Row(String sourcePath, String className, String checksum, String description, String responsibility, @Nullable String pattern1, @Nullable String pattern2, @Nullable String pattern3, long inferenceTimeMs) {
            this.sourcePath = sourcePath;
            this.className = className;
            this.checksum = checksum;
            this.description = description;
            this.responsibility = responsibility;
            this.pattern1 = pattern1;
            this.pattern2 = pattern2;
            this.pattern3 = pattern3;
            this.inferenceTimeMs = inferenceTimeMs;
        }

        @Generated
        public String getSourcePath() {
            return this.sourcePath;
        }

        @Generated
        public String getClassName() {
            return this.className;
        }

        @Generated
        public String getChecksum() {
            return this.checksum;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public String getResponsibility() {
            return this.responsibility;
        }

        @Generated
        public @Nullable String getPattern1() {
            return this.pattern1;
        }

        @Generated
        public @Nullable String getPattern2() {
            return this.pattern2;
        }

        @Generated
        public @Nullable String getPattern3() {
            return this.pattern3;
        }

        @Generated
        public long getInferenceTimeMs() {
            return this.inferenceTimeMs;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            if (this.getInferenceTimeMs() != other.getInferenceTimeMs()) {
                return false;
            }
            String this$sourcePath = this.getSourcePath();
            String other$sourcePath = other.getSourcePath();
            if (this$sourcePath == null ? other$sourcePath != null : !this$sourcePath.equals(other$sourcePath)) {
                return false;
            }
            String this$className = this.getClassName();
            String other$className = other.getClassName();
            if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
                return false;
            }
            String this$checksum = this.getChecksum();
            String other$checksum = other.getChecksum();
            if (this$checksum == null ? other$checksum != null : !this$checksum.equals(other$checksum)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            String this$responsibility = this.getResponsibility();
            String other$responsibility = other.getResponsibility();
            if (this$responsibility == null ? other$responsibility != null : !this$responsibility.equals(other$responsibility)) {
                return false;
            }
            String this$pattern1 = this.getPattern1();
            String other$pattern1 = other.getPattern1();
            if (this$pattern1 == null ? other$pattern1 != null : !this$pattern1.equals(other$pattern1)) {
                return false;
            }
            String this$pattern2 = this.getPattern2();
            String other$pattern2 = other.getPattern2();
            if (this$pattern2 == null ? other$pattern2 != null : !this$pattern2.equals(other$pattern2)) {
                return false;
            }
            String this$pattern3 = this.getPattern3();
            String other$pattern3 = other.getPattern3();
            return !(this$pattern3 == null ? other$pattern3 != null : !this$pattern3.equals(other$pattern3));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $inferenceTimeMs = this.getInferenceTimeMs();
            result = result * 59 + (int)($inferenceTimeMs >>> 32 ^ $inferenceTimeMs);
            String $sourcePath = this.getSourcePath();
            result = result * 59 + ($sourcePath == null ? 43 : $sourcePath.hashCode());
            String $className = this.getClassName();
            result = result * 59 + ($className == null ? 43 : $className.hashCode());
            String $checksum = this.getChecksum();
            result = result * 59 + ($checksum == null ? 43 : $checksum.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            String $responsibility = this.getResponsibility();
            result = result * 59 + ($responsibility == null ? 43 : $responsibility.hashCode());
            String $pattern1 = this.getPattern1();
            result = result * 59 + ($pattern1 == null ? 43 : $pattern1.hashCode());
            String $pattern2 = this.getPattern2();
            result = result * 59 + ($pattern2 == null ? 43 : $pattern2.hashCode());
            String $pattern3 = this.getPattern3();
            result = result * 59 + ($pattern3 == null ? 43 : $pattern3.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ClassDescriptions.Row(sourcePath=" + this.getSourcePath() + ", className=" + this.getClassName() + ", checksum=" + this.getChecksum() + ", description=" + this.getDescription() + ", responsibility=" + this.getResponsibility() + ", pattern1=" + this.getPattern1() + ", pattern2=" + this.getPattern2() + ", pattern3=" + this.getPattern3() + ", inferenceTimeMs=" + this.getInferenceTimeMs() + ")";
        }
    }
}

