/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.prethink.calm;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.DataTable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.prethink.Prethink;
import org.openrewrite.prethink.calm.CalmDestination;
import org.openrewrite.prethink.calm.CalmDocument;
import org.openrewrite.prethink.calm.CalmEndpoint;
import org.openrewrite.prethink.calm.CalmInterface;
import org.openrewrite.prethink.calm.CalmNode;
import org.openrewrite.prethink.calm.CalmRelationship;
import org.openrewrite.prethink.table.ClassDescriptions;
import org.openrewrite.prethink.table.DataAssets;
import org.openrewrite.prethink.table.DatabaseConnections;
import org.openrewrite.prethink.table.ExternalServiceCalls;
import org.openrewrite.prethink.table.MessagingConnections;
import org.openrewrite.prethink.table.ProjectMetadata;
import org.openrewrite.prethink.table.SecurityConfiguration;
import org.openrewrite.prethink.table.ServerConfiguration;
import org.openrewrite.prethink.table.ServiceEndpoints;
import org.openrewrite.text.PlainText;

public final class GenerateCalmArchitecture
extends ScanningRecipe<Accumulator> {
    private static final String CALM_FILENAME = "calm-architecture.json";
    private static final String CALM_SCHEMA = "https://calm.finos.org/draft/2025-03/meta/calm.json";
    private static final String PLACEHOLDER_CONTENT = "{}";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT).setSerializationInclusion(JsonInclude.Include.NON_NULL);

    public String getDisplayName() {
        return "Generate [CALM](https://calm.finos.org/) architecture";
    }

    public String getDescription() {
        return "Generate a FINOS CALM (Common Architecture Language Model) JSON file from discovered service endpoints, database connections, external service calls, and messaging connections.";
    }

    public boolean causesAnotherCycle() {
        return true;
    }

    public Accumulator getInitialValue(ExecutionContext ctx) {
        return new Accumulator(new HashSet<Path>(), false);
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final Accumulator acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                SourceFile sf;
                Path path;
                if (tree instanceof SourceFile && (path = (sf = (SourceFile)tree).getSourcePath()).startsWith(Prethink.CONTEXT_DIR)) {
                    acc.getExistingContextPaths().add(path);
                }
                return tree;
            }
        };
    }

    public Collection<SourceFile> generate(Accumulator acc, ExecutionContext ctx) {
        if (ctx.getCycle() == 1) {
            ArrayList<SourceFile> generated = new ArrayList<SourceFile>();
            Path calmPath = Prethink.CONTEXT_DIR.resolve(CALM_FILENAME);
            if (!acc.getExistingContextPaths().contains(calmPath)) {
                PlainText calmFile = PlainText.builder().text(PLACEHOLDER_CONTENT).sourcePath(calmPath).build();
                generated.add((SourceFile)calmFile);
                acc.setCreatedPlaceholder(true);
            }
            return generated;
        }
        return Collections.emptyList();
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(final Accumulator acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                PlainText pt;
                Path path;
                if (ctx.getCycle() == 1 && acc.isCreatedPlaceholder()) {
                    return tree;
                }
                if (tree instanceof PlainText && (path = (pt = (PlainText)tree).getSourcePath()).equals(Prethink.CONTEXT_DIR.resolve(GenerateCalmArchitecture.CALM_FILENAME))) {
                    String newContent = GenerateCalmArchitecture.this.generateCalmJsonFromDataTables(ctx);
                    if (newContent == null) {
                        if (GenerateCalmArchitecture.PLACEHOLDER_CONTENT.equals(pt.getText()) || pt.getText().trim().isEmpty()) {
                            return null;
                        }
                        return tree;
                    }
                    if (!newContent.equals(pt.getText())) {
                        return pt.withText(newContent);
                    }
                }
                return tree;
            }
        };
    }

    private <T> List<T> getTableRows(Map<DataTable<?>, List<?>> allTables, Class<? extends DataTable<?>> tableClass) {
        for (Map.Entry<DataTable<?>, List<?>> entry : allTables.entrySet()) {
            if (!entry.getKey().getClass().getName().equals(tableClass.getName())) continue;
            return entry.getValue();
        }
        return Collections.emptyList();
    }

    private @Nullable String generateCalmJsonFromDataTables(ExecutionContext ctx) {
        Map allTables = (Map)ctx.getMessage("org.openrewrite.dataTables");
        if (allTables == null || allTables.isEmpty()) {
            return null;
        }
        List<ServiceEndpoints.Row> endpoints = this.getTableRows(allTables, ServiceEndpoints.class);
        List<DatabaseConnections.Row> databases = this.getTableRows(allTables, DatabaseConnections.class);
        List<ExternalServiceCalls.Row> externalCalls = this.getTableRows(allTables, ExternalServiceCalls.class);
        List<MessagingConnections.Row> messaging = this.getTableRows(allTables, MessagingConnections.class);
        if (endpoints.isEmpty() && databases.isEmpty() && externalCalls.isEmpty() && messaging.isEmpty()) {
            return null;
        }
        CalmBuilder builder = new CalmBuilder(allTables);
        builder.addSystemNode();
        builder.addServiceNodes(endpoints);
        builder.addDataAssetNodes();
        builder.addWebClientNode();
        builder.addDatabaseNodes(databases);
        builder.addExternalServiceNodes(externalCalls);
        builder.addMessagingNodes(messaging);
        builder.addComposedOfRelationships();
        try {
            return OBJECT_MAPPER.writeValueAsString((Object)builder.build());
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    private String toKebabCase(@Nullable String input) {
        if (input == null) {
            return "unknown";
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (Character.isUpperCase(c)) {
                if (i > 0 && result.length() > 0 && result.charAt(result.length() - 1) != '-') {
                    result.append('-');
                }
                result.append(Character.toLowerCase(c));
                continue;
            }
            if (c == ' ' || c == '_') {
                if (result.length() <= 0 || result.charAt(result.length() - 1) == '-') continue;
                result.append('-');
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    @Generated
    public GenerateCalmArchitecture() {
    }

    @Generated
    public String toString() {
        return "GenerateCalmArchitecture()";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GenerateCalmArchitecture)) {
            return false;
        }
        GenerateCalmArchitecture other = (GenerateCalmArchitecture)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GenerateCalmArchitecture;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public static class Accumulator {
        final Set<Path> existingContextPaths;
        boolean createdPlaceholder;

        @Generated
        public Set<Path> getExistingContextPaths() {
            return this.existingContextPaths;
        }

        @Generated
        public boolean isCreatedPlaceholder() {
            return this.createdPlaceholder;
        }

        @Generated
        public void setCreatedPlaceholder(boolean createdPlaceholder) {
            this.createdPlaceholder = createdPlaceholder;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Accumulator)) {
                return false;
            }
            Accumulator other = (Accumulator)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isCreatedPlaceholder() != other.isCreatedPlaceholder()) {
                return false;
            }
            Set<Path> this$existingContextPaths = this.getExistingContextPaths();
            Set<Path> other$existingContextPaths = other.getExistingContextPaths();
            return !(this$existingContextPaths == null ? other$existingContextPaths != null : !((Object)this$existingContextPaths).equals(other$existingContextPaths));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Accumulator;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isCreatedPlaceholder() ? 79 : 97);
            Set<Path> $existingContextPaths = this.getExistingContextPaths();
            result = result * 59 + ($existingContextPaths == null ? 43 : ((Object)$existingContextPaths).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "GenerateCalmArchitecture.Accumulator(existingContextPaths=" + this.getExistingContextPaths() + ", createdPlaceholder=" + this.isCreatedPlaceholder() + ")";
        }

        @Generated
        public Accumulator(Set<Path> existingContextPaths, boolean createdPlaceholder) {
            this.existingContextPaths = existingContextPaths;
            this.createdPlaceholder = createdPlaceholder;
        }
    }

    private class CalmBuilder {
        private final List<CalmNode> nodes = new ArrayList<CalmNode>();
        private final List<CalmRelationship> relationships = new ArrayList<CalmRelationship>();
        private final Map<String, String> serviceClassToId = new HashMap<String, String>();
        private final List<String> serviceNodeIds = new ArrayList<String>();
        private final Map<String, String> aiDescriptionsByClass = new HashMap<String, String>();
        private final List<ServerConfiguration.Row> serverConfigs;
        private final List<DataAssets.Row> dataAssets;
        private final List<ProjectMetadata.Row> projectMetadata;
        private final List<SecurityConfiguration.Row> securityConfigs;
        private final String serverProtocol;
        private final int serverPort;
        private String systemNodeId;

        CalmBuilder(Map<DataTable<?>, List<?>> allTables) {
            this.serverConfigs = GenerateCalmArchitecture.this.getTableRows(allTables, ServerConfiguration.class);
            this.dataAssets = GenerateCalmArchitecture.this.getTableRows(allTables, DataAssets.class);
            this.projectMetadata = GenerateCalmArchitecture.this.getTableRows(allTables, ProjectMetadata.class);
            this.securityConfigs = GenerateCalmArchitecture.this.getTableRows(allTables, SecurityConfiguration.class);
            List classDescriptions = GenerateCalmArchitecture.this.getTableRows(allTables, ClassDescriptions.class);
            for (ClassDescriptions.Row row : classDescriptions) {
                this.aiDescriptionsByClass.put(row.getClassName(), row.getDescription());
            }
            if (!this.serverConfigs.isEmpty()) {
                ServerConfiguration.Row config = this.serverConfigs.get(0);
                this.serverProtocol = config.getProtocol();
                this.serverPort = config.getPort();
            } else {
                this.serverProtocol = "HTTP";
                this.serverPort = 8080;
            }
        }

        void addSystemNode() {
            if (this.projectMetadata.isEmpty()) {
                return;
            }
            ProjectMetadata.Row project = this.projectMetadata.get(0);
            this.systemNodeId = GenerateCalmArchitecture.this.toKebabCase(project.getArtifactId());
            String systemName = project.getName() != null ? project.getName() : project.getArtifactId();
            String systemDescription = project.getDescription() != null ? project.getDescription() : "System containing " + project.getArtifactId() + " services";
            this.nodes.add(new CalmNode(this.systemNodeId, "system", systemName, systemDescription, null));
        }

        void addServiceNodes(List<ServiceEndpoints.Row> endpoints) {
            LinkedHashMap<String, List> endpointsByClass = new LinkedHashMap<String, List>();
            for (ServiceEndpoints.Row row : endpoints) {
                if (row == null || row.getServiceClass() == null) continue;
                endpointsByClass.computeIfAbsent(row.getServiceClass(), k -> new ArrayList()).add(row);
            }
            for (Map.Entry entry : endpointsByClass.entrySet()) {
                ServiceEndpoints.Row first;
                String serviceClass = (String)entry.getKey();
                List classEndpoints = (List)entry.getValue();
                if (classEndpoints == null || classEndpoints.isEmpty() || (first = (ServiceEndpoints.Row)classEndpoints.get(0)) == null) continue;
                String nodeId = GenerateCalmArchitecture.this.toKebabCase(first.getServiceName());
                this.serviceClassToId.put(serviceClass, nodeId);
                List<CalmInterface> interfaces = Collections.singletonList(new CalmInterface(nodeId + "-api", this.serverProtocol, this.serverPort));
                String description = this.buildServiceDescription(serviceClass, classEndpoints);
                this.nodes.add(new CalmNode(nodeId, "service", first.getServiceName(), description, interfaces));
                this.serviceNodeIds.add(nodeId);
            }
        }

        private String buildServiceDescription(String serviceClass, List<ServiceEndpoints.Row> classEndpoints) {
            String aiDescription = this.aiDescriptionsByClass.get(serviceClass);
            if (aiDescription != null && !aiDescription.isEmpty()) {
                return aiDescription;
            }
            StringBuilder sb = new StringBuilder("REST API with endpoints: ");
            int count = 0;
            for (ServiceEndpoints.Row ep : classEndpoints) {
                if (count > 0) {
                    sb.append(", ");
                }
                sb.append(ep.getHttpMethod()).append(" ").append(ep.getPath());
                if (++count < 5) continue;
                sb.append(" and ").append(classEndpoints.size() - 5).append(" more");
                break;
            }
            return sb.toString();
        }

        void addDataAssetNodes() {
            HashSet<String> seen = new HashSet<String>();
            for (DataAssets.Row asset : this.dataAssets) {
                String nodeId = GenerateCalmArchitecture.this.toKebabCase(asset.getSimpleName()) + "-data";
                if (!seen.add(nodeId)) continue;
                String description = asset.getDescription() != null ? asset.getDescription() : asset.getAssetType() + " " + asset.getSimpleName();
                this.nodes.add(new CalmNode(nodeId, "data-asset", asset.getSimpleName(), description, null));
            }
        }

        void addWebClientNode() {
            boolean hasCorsConfig = this.securityConfigs.stream().anyMatch(sc -> "CORS".equals(sc.getConfigurationType()));
            if (!hasCorsConfig || this.serviceNodeIds.isEmpty()) {
                return;
            }
            String webClientNodeId = "web-client";
            String origins = this.securityConfigs.stream().filter(sc -> "CORS".equals(sc.getConfigurationType()) && sc.getAllowedOrigins() != null).map(SecurityConfiguration.Row::getAllowedOrigins).findFirst().orElse("configured origins");
            this.nodes.add(new CalmNode(webClientNodeId, "webclient", "Web Client", "Web application client accessing the API from " + origins, null));
            String primaryServiceId = this.serviceNodeIds.get(0);
            this.relationships.add(new CalmRelationship(webClientNodeId + "-interacts-" + primaryServiceId, "interacts", new CalmEndpoint(webClientNodeId, null), new CalmDestination(primaryServiceId, primaryServiceId + "-api"), this.serverProtocol));
        }

        void addDatabaseNodes(List<DatabaseConnections.Row> databases) {
            HashSet<String> seen = new HashSet<String>();
            for (DatabaseConnections.Row db : databases) {
                String nodeId = GenerateCalmArchitecture.this.toKebabCase(db.getEntityName()) + "-db";
                if (!seen.add(nodeId)) continue;
                String dbType = db.getDatabaseType() != null ? db.getDatabaseType() : "SQL";
                this.nodes.add(new CalmNode(nodeId, "database", db.getEntityName() + " Store", dbType + " database for " + db.getEntityName() + " data", null));
                String serviceId = this.findServiceForClass(db.getRepositoryClass());
                if (serviceId == null && db.getEntityClass() != null) {
                    serviceId = this.findServiceInSamePackage(db.getEntityClass());
                }
                if (serviceId == null) continue;
                this.relationships.add(new CalmRelationship(serviceId + "-to-" + nodeId, "connects", new CalmEndpoint(serviceId, null), new CalmDestination(nodeId, "jdbc"), "JDBC"));
            }
        }

        void addExternalServiceNodes(List<ExternalServiceCalls.Row> externalCalls) {
            HashSet<String> seen = new HashSet<String>();
            for (ExternalServiceCalls.Row ext : externalCalls) {
                String nodeId = GenerateCalmArchitecture.this.toKebabCase(ext.getTargetService());
                if (!seen.add(nodeId)) continue;
                this.nodes.add(new CalmNode(nodeId, "service", ext.getTargetService(), "External " + ext.getClientType() + " service", null));
                String callerServiceId = this.findServiceForClass(ext.getClientClass());
                if (callerServiceId == null) {
                    callerServiceId = this.findServiceInSamePackage(ext.getClientClass());
                }
                if (callerServiceId == null) continue;
                String protocol = ext.getProtocol() != null ? ext.getProtocol() : "HTTPS";
                this.relationships.add(new CalmRelationship(callerServiceId + "-to-" + nodeId, "connects", new CalmEndpoint(callerServiceId, null), new CalmDestination(nodeId, "api"), protocol));
            }
        }

        void addMessagingNodes(List<MessagingConnections.Row> messaging) {
            HashMap<String, String> destinationToNodeId = new HashMap<String, String>();
            for (MessagingConnections.Row msg : messaging) {
                String protocol;
                String serviceId;
                String nodeId = GenerateCalmArchitecture.this.toKebabCase(msg.getDestination()) + "-" + msg.getMessagingType().toLowerCase().replace(" ", "-");
                if (!destinationToNodeId.containsKey(msg.getDestination())) {
                    destinationToNodeId.put(msg.getDestination(), nodeId);
                    this.nodes.add(new CalmNode(nodeId, "network", msg.getDestination(), msg.getMessagingType() + " " + (msg.getRole().equals("consumer") ? "topic/queue" : "destination"), null));
                }
                if ((serviceId = this.findServiceForClass(msg.getClassName())) == null) {
                    serviceId = this.findServiceInSamePackage(msg.getClassName());
                }
                if (serviceId == null) continue;
                String msgNodeId = (String)destinationToNodeId.get(msg.getDestination());
                String string = protocol = msg.getMessagingType().contains("Kafka") ? "TCP" : "AMQP";
                if (msg.getRole().equals("producer")) {
                    this.relationships.add(new CalmRelationship(serviceId + "-publishes-to-" + msgNodeId, "connects", new CalmEndpoint(serviceId, null), new CalmDestination(msgNodeId, null), protocol));
                    continue;
                }
                this.relationships.add(new CalmRelationship(msgNodeId + "-consumed-by-" + serviceId, "connects", new CalmEndpoint(msgNodeId, null), new CalmDestination(serviceId, null), protocol));
            }
        }

        void addComposedOfRelationships() {
            if (this.systemNodeId == null) {
                return;
            }
            for (String serviceId : this.serviceNodeIds) {
                this.relationships.add(new CalmRelationship(this.systemNodeId + "-contains-" + serviceId, "composed-of", new CalmEndpoint(this.systemNodeId, null), new CalmDestination(serviceId, null), null));
            }
        }

        private @Nullable String findServiceForClass(@Nullable String className) {
            return className == null ? null : this.serviceClassToId.get(className);
        }

        private @Nullable String findServiceInSamePackage(@Nullable String className) {
            if (className == null) {
                return null;
            }
            String pkg = className.contains(".") ? className.substring(0, className.lastIndexOf(46)) : "";
            for (Map.Entry<String, String> entry : this.serviceClassToId.entrySet()) {
                String servicePkg;
                String serviceClass = entry.getKey();
                String string = servicePkg = serviceClass.contains(".") ? serviceClass.substring(0, serviceClass.lastIndexOf(46)) : "";
                if (!servicePkg.equals(pkg) && !servicePkg.startsWith(pkg) && !pkg.startsWith(servicePkg)) continue;
                return entry.getValue();
            }
            return null;
        }

        CalmDocument build() {
            return new CalmDocument(GenerateCalmArchitecture.CALM_SCHEMA, this.nodes, this.relationships);
        }
    }
}

