/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.prethink;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.marker.Markers;
import org.openrewrite.prethink.table.ContextRegistry;
import org.openrewrite.text.PlainText;
import org.openrewrite.text.PlainTextVisitor;

public final class UpdateAgentConfig
extends ScanningRecipe<Accumulator> {
    private final transient ContextRegistry contextRegistry = new ContextRegistry((Recipe)this);
    private static final String CONTEXT_SECTION_MARKER = "<!-- prethink-context -->";
    private static final Pattern CONTEXT_SECTION_PATTERN = Pattern.compile("<!-- prethink-context -->.*?<!-- /prethink-context -->", 32);
    private static final List<String> AGENT_CONFIG_FILES = Arrays.asList("CLAUDE.md", ".cursorrules", ".github/copilot-instructions.md");
    @Option(displayName="Target config file", description="Which agent config file to update. If not specified, updates all found files.", required=false, example="CLAUDE.md")
    private final @Nullable String targetConfigFile;

    public String getDisplayName() {
        return "Update agent configuration files";
    }

    public String getDescription() {
        return "Update coding agent configuration files (CLAUDE.md, .cursorrules, etc.) to include references to Moderne Prethink context files in .moderne/context/.";
    }

    public Accumulator getInitialValue(ExecutionContext ctx) {
        return new Accumulator(new ArrayList<ContextEntry>(), new HashSet<String>());
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final Accumulator acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                block4: {
                    String path;
                    block5: {
                        PlainText pt;
                        ContextEntry entry;
                        if (!(tree instanceof SourceFile)) break block4;
                        SourceFile sf = (SourceFile)tree;
                        path = sf.getSourcePath().toString();
                        if (path.startsWith(".moderne/context/") && path.endsWith(".md") && sf instanceof PlainText && (entry = UpdateAgentConfig.this.parseContextMarkdown((pt = (PlainText)sf).getText(), path)) != null) {
                            acc.getContextEntries().add(entry);
                        }
                        String fileName = sf.getSourcePath().getFileName().toString();
                        if (AGENT_CONFIG_FILES.contains(fileName)) break block5;
                        if (!AGENT_CONFIG_FILES.stream().anyMatch(path::endsWith)) break block4;
                    }
                    acc.getFoundConfigFiles().add(path);
                }
                return tree;
            }
        };
    }

    private @Nullable ContextEntry parseContextMarkdown(String content, String filePath) {
        String[] lines;
        String displayName = null;
        String shortDescription = null;
        for (String line : lines = content.split("\n")) {
            if (line.startsWith("# ") && displayName == null) {
                displayName = line.substring(2).trim();
                continue;
            }
            if (!line.startsWith("## ") || shortDescription != null || displayName == null) continue;
            shortDescription = line.substring(3).trim();
            break;
        }
        if (displayName != null && shortDescription != null) {
            return new ContextEntry(displayName, shortDescription, filePath);
        }
        return null;
    }

    public Collection<? extends SourceFile> generate(Accumulator acc, ExecutionContext ctx) {
        ArrayList<PlainText> generated = new ArrayList<PlainText>();
        for (ContextEntry entry : acc.getContextEntries()) {
            this.contextRegistry.insertRow(ctx, new ContextRegistry.Row(entry.getDisplayName(), entry.getShortDescription(), entry.getContextFile()));
        }
        if (acc.getContextEntries().isEmpty()) {
            return generated;
        }
        if (acc.getFoundConfigFiles().isEmpty()) {
            String target = this.targetConfigFile != null ? this.targetConfigFile : "CLAUDE.md";
            PlainText newConfig = PlainText.builder().id(Tree.randomId()).sourcePath(Paths.get(target, new String[0])).markers(Markers.EMPTY).text(this.generateContextSection(acc.getContextEntries())).build();
            generated.add(newConfig);
        }
        return generated;
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(final Accumulator acc) {
        return new PlainTextVisitor<ExecutionContext>(){

            /*
             * Unable to fully structure code
             */
            public PlainText visitText(PlainText text, ExecutionContext ctx) {
                path = text.getSourcePath().toString();
                fileName = text.getSourcePath().getFileName().toString();
                if (UpdateAgentConfig.access$100().contains(fileName)) ** GOTO lbl-1000
                if (UpdateAgentConfig.access$100().stream().anyMatch((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, endsWith(java.lang.String ), (Ljava/lang/String;)Z)((String)path))) lbl-1000:
                // 2 sources

                {
                    v0 = true;
                } else {
                    v0 = isConfigFile = false;
                }
                if (!isConfigFile) {
                    return text;
                }
                if (UpdateAgentConfig.access$200(UpdateAgentConfig.this) != null && !path.equals(UpdateAgentConfig.access$200(UpdateAgentConfig.this)) && !fileName.equals(UpdateAgentConfig.access$200(UpdateAgentConfig.this))) {
                    return text;
                }
                if (acc.getContextEntries().isEmpty()) {
                    return text;
                }
                content = text.getText();
                newSection = UpdateAgentConfig.access$300(UpdateAgentConfig.this, acc.getContextEntries());
                matcher = UpdateAgentConfig.access$400().matcher(content);
                if (matcher.find()) {
                    content = matcher.replaceFirst(Matcher.quoteReplacement(newSection));
                } else {
                    if (!content.endsWith("\n")) {
                        content = content + "\n";
                    }
                    content = content + "\n" + newSection;
                }
                return text.withText(content);
            }
        };
    }

    private String generateContextSection(List<ContextEntry> contextEntries) {
        String template = this.loadTemplate();
        String contextTable = this.generateContextTable(contextEntries);
        String content = template.replace("{{CONTEXT_TABLE}}", contextTable);
        return "<!-- prethink-context -->\n" + content + "\n<!-- /prethink-context -->";
    }

    private String generateContextTable(List<ContextEntry> contextEntries) {
        StringBuilder sb = new StringBuilder();
        sb.append("| Context | Description | Details |\n");
        sb.append("|---------|-------------|--------|\n");
        for (ContextEntry entry : contextEntries) {
            sb.append("| ").append(entry.getDisplayName()).append(" | ").append(entry.getShortDescription()).append(" | [`").append(Paths.get(entry.getContextFile(), new String[0]).getFileName()).append("`](").append(entry.getContextFile()).append(") |\n");
        }
        return sb.toString().trim();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String loadTemplate() {
        try (InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/org/openrewrite/prethink/prompts/agent-config-section.txt");){
            String string;
            if (is == null) {
                throw new IllegalStateException("Template file not found: /org/openrewrite/prethink/prompts/agent-config-section.txt");
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
                string = reader.lines().collect(Collectors.joining("\n"));
            }
            return string;
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to load template file", e);
        }
    }

    @Generated
    public UpdateAgentConfig(@Nullable String targetConfigFile) {
        this.targetConfigFile = targetConfigFile;
    }

    @Generated
    public ContextRegistry getContextRegistry() {
        return this.contextRegistry;
    }

    @Generated
    public @Nullable String getTargetConfigFile() {
        return this.targetConfigFile;
    }

    @Generated
    public String toString() {
        return "UpdateAgentConfig(contextRegistry=" + (Object)((Object)this.getContextRegistry()) + ", targetConfigFile=" + this.getTargetConfigFile() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateAgentConfig)) {
            return false;
        }
        UpdateAgentConfig other = (UpdateAgentConfig)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$targetConfigFile = this.getTargetConfigFile();
        String other$targetConfigFile = other.getTargetConfigFile();
        return !(this$targetConfigFile == null ? other$targetConfigFile != null : !this$targetConfigFile.equals(other$targetConfigFile));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UpdateAgentConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $targetConfigFile = this.getTargetConfigFile();
        result = result * 59 + ($targetConfigFile == null ? 43 : $targetConfigFile.hashCode());
        return result;
    }

    static /* synthetic */ String access$200(UpdateAgentConfig x0) {
        return x0.targetConfigFile;
    }

    static /* synthetic */ String access$300(UpdateAgentConfig x0, List x1) {
        return x0.generateContextSection(x1);
    }

    static /* synthetic */ Pattern access$400() {
        return CONTEXT_SECTION_PATTERN;
    }

    public static final class ContextEntry {
        private final String displayName;
        private final String shortDescription;
        private final String contextFile;

        @Generated
        public ContextEntry(String displayName, String shortDescription, String contextFile) {
            this.displayName = displayName;
            this.shortDescription = shortDescription;
            this.contextFile = contextFile;
        }

        @Generated
        public String getDisplayName() {
            return this.displayName;
        }

        @Generated
        public String getShortDescription() {
            return this.shortDescription;
        }

        @Generated
        public String getContextFile() {
            return this.contextFile;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ContextEntry)) {
                return false;
            }
            ContextEntry other = (ContextEntry)o;
            String this$displayName = this.getDisplayName();
            String other$displayName = other.getDisplayName();
            if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
                return false;
            }
            String this$shortDescription = this.getShortDescription();
            String other$shortDescription = other.getShortDescription();
            if (this$shortDescription == null ? other$shortDescription != null : !this$shortDescription.equals(other$shortDescription)) {
                return false;
            }
            String this$contextFile = this.getContextFile();
            String other$contextFile = other.getContextFile();
            return !(this$contextFile == null ? other$contextFile != null : !this$contextFile.equals(other$contextFile));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $displayName = this.getDisplayName();
            result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
            String $shortDescription = this.getShortDescription();
            result = result * 59 + ($shortDescription == null ? 43 : $shortDescription.hashCode());
            String $contextFile = this.getContextFile();
            result = result * 59 + ($contextFile == null ? 43 : $contextFile.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "UpdateAgentConfig.ContextEntry(displayName=" + this.getDisplayName() + ", shortDescription=" + this.getShortDescription() + ", contextFile=" + this.getContextFile() + ")";
        }
    }

    public static final class Accumulator {
        private final List<ContextEntry> contextEntries;
        private final Set<String> foundConfigFiles;

        @Generated
        public Accumulator(List<ContextEntry> contextEntries, Set<String> foundConfigFiles) {
            this.contextEntries = contextEntries;
            this.foundConfigFiles = foundConfigFiles;
        }

        @Generated
        public List<ContextEntry> getContextEntries() {
            return this.contextEntries;
        }

        @Generated
        public Set<String> getFoundConfigFiles() {
            return this.foundConfigFiles;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Accumulator)) {
                return false;
            }
            Accumulator other = (Accumulator)o;
            List<ContextEntry> this$contextEntries = this.getContextEntries();
            List<ContextEntry> other$contextEntries = other.getContextEntries();
            if (this$contextEntries == null ? other$contextEntries != null : !((Object)this$contextEntries).equals(other$contextEntries)) {
                return false;
            }
            Set<String> this$foundConfigFiles = this.getFoundConfigFiles();
            Set<String> other$foundConfigFiles = other.getFoundConfigFiles();
            return !(this$foundConfigFiles == null ? other$foundConfigFiles != null : !((Object)this$foundConfigFiles).equals(other$foundConfigFiles));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<ContextEntry> $contextEntries = this.getContextEntries();
            result = result * 59 + ($contextEntries == null ? 43 : ((Object)$contextEntries).hashCode());
            Set<String> $foundConfigFiles = this.getFoundConfigFiles();
            result = result * 59 + ($foundConfigFiles == null ? 43 : ((Object)$foundConfigFiles).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "UpdateAgentConfig.Accumulator(contextEntries=" + this.getContextEntries() + ", foundConfigFiles=" + this.getFoundConfigFiles() + ")";
        }
    }
}

