/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.prethink;

import com.univocity.parsers.csv.CsvWriter;
import com.univocity.parsers.csv.CsvWriterSettings;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.prethink.Prethink;
import org.openrewrite.text.PlainText;

public final class ExportContext
extends ScanningRecipe<Accumulator> {
    @Option(displayName="Display name", description="The display name for this context, shown in agent configurations.", example="Test Coverage")
    private final String displayName;
    @Option(displayName="Short description", description="A brief description of what context this provides to the model.", example="Maps test methods to implementation methods they verify")
    private final String shortDescription;
    @Option(displayName="Long description", description="A detailed description of the context and how to use it.", example="This context maps each test method to the implementation methods it calls...")
    private final String longDescription;
    @Option(displayName="Data tables to export", description="Fully qualified class names of DataTables to export to CSV.", example="org.openrewrite.prethink.table.TestMapping")
    private final List<String> dataTables;

    public String getDisplayName() {
        return "Export context files";
    }

    public String getDescription() {
        return "Export DataTables to CSV files in `.moderne/context/` along with a markdown description file. The markdown file describes the context and includes schema information for each data table.";
    }

    public boolean causesAnotherCycle() {
        return true;
    }

    public Accumulator getInitialValue(ExecutionContext ctx) {
        return new Accumulator(new HashSet<Path>());
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final Accumulator acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                SourceFile sf;
                Path path;
                if (tree instanceof SourceFile && (path = (sf = (SourceFile)tree).getSourcePath()).startsWith(Prethink.CONTEXT_DIR)) {
                    acc.getExistingContextPaths().add(path);
                }
                return tree;
            }
        };
    }

    public Collection<SourceFile> generate(Accumulator acc, ExecutionContext ctx) {
        if (ctx.getCycle() == 1) {
            return Collections.emptyList();
        }
        ArrayList<SourceFile> contextFiles = new ArrayList<SourceFile>();
        Map allTables = (Map)ctx.getMessage("org.openrewrite.dataTables");
        if (allTables == null || allTables.isEmpty()) {
            return contextFiles;
        }
        ArrayList<DataTableInfo> exportedTables = new ArrayList<DataTableInfo>();
        for (Map.Entry entry : allTables.entrySet()) {
            DataTable table = (DataTable)entry.getKey();
            List rows = (List)entry.getValue();
            String tableFqn = table.getClass().getName();
            if (!this.dataTables.contains(tableFqn)) continue;
            String filename = this.tableToFilename(tableFqn);
            String csvContent = this.exportToCsv(table, rows);
            Path filePath = Prethink.CONTEXT_DIR.resolve(filename);
            exportedTables.add(new DataTableInfo(table.getDisplayName(), table.getDescription(), filename, this.getColumnInfo(table, rows)));
            if (acc.getExistingContextPaths().contains(filePath)) continue;
            PlainText csvFile = PlainText.builder().text(csvContent).sourcePath(filePath).build();
            contextFiles.add((SourceFile)csvFile);
        }
        if (!exportedTables.isEmpty()) {
            String mdFilename = this.toKebabCase(this.displayName) + ".md";
            Path mdPath = Prethink.CONTEXT_DIR.resolve(mdFilename);
            if (!acc.getExistingContextPaths().contains(mdPath)) {
                String mdContent = this.generateMarkdown(exportedTables);
                PlainText mdFile = PlainText.builder().text(mdContent).sourcePath(mdPath).build();
                contextFiles.add((SourceFile)mdFile);
            }
        }
        return contextFiles;
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(Accumulator acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                PlainText pt;
                Path path;
                if (ctx.getCycle() == 1) {
                    return tree;
                }
                if (tree instanceof PlainText && (path = (pt = (PlainText)tree).getSourcePath()).startsWith(Prethink.CONTEXT_DIR)) {
                    Map allTables;
                    String newContent;
                    String filename = path.getFileName().toString();
                    if (filename.endsWith(".csv") && (newContent = ExportContext.this.getCsvContentForFile(filename, ctx)) != null && !newContent.equals(pt.getText())) {
                        return pt.withText(newContent);
                    }
                    String expectedMdFilename = ExportContext.this.toKebabCase(ExportContext.this.displayName) + ".md";
                    if (filename.equals(expectedMdFilename) && (allTables = (Map)ctx.getMessage("org.openrewrite.dataTables")) != null) {
                        String newContent2;
                        ArrayList<DataTableInfo> exportedTables = new ArrayList<DataTableInfo>();
                        for (Map.Entry entry : allTables.entrySet()) {
                            DataTable table = (DataTable)entry.getKey();
                            String tableFqn = table.getClass().getName();
                            if (!ExportContext.this.dataTables.contains(tableFqn)) continue;
                            exportedTables.add(new DataTableInfo(table.getDisplayName(), table.getDescription(), ExportContext.this.tableToFilename(tableFqn), ExportContext.this.getColumnInfo(table, (List)entry.getValue())));
                        }
                        if (!exportedTables.isEmpty() && !(newContent2 = ExportContext.this.generateMarkdown(exportedTables)).equals(pt.getText())) {
                            return pt.withText(newContent2);
                        }
                    }
                }
                return tree;
            }
        };
    }

    public String getContextFilename() {
        return this.toKebabCase(this.displayName) + ".md";
    }

    private String generateMarkdown(List<DataTableInfo> tables) {
        StringBuilder sb = new StringBuilder();
        sb.append("# ").append(this.displayName).append("\n\n");
        sb.append("## ").append(this.shortDescription).append("\n\n");
        sb.append(this.longDescription).append("\n\n");
        sb.append("## Data Tables\n\n");
        for (DataTableInfo table : tables) {
            sb.append("### ").append(table.displayName).append("\n\n");
            sb.append("**File:** [`").append(table.filename).append("`](").append(table.filename).append(")\n\n");
            sb.append(table.description).append("\n\n");
            if (table.columns.isEmpty()) continue;
            sb.append("| Column | Description |\n");
            sb.append("|--------|-------------|\n");
            for (ColumnInfo col : table.columns) {
                sb.append("| ").append(col.displayName).append(" | ").append(col.description).append(" |\n");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private List<ColumnInfo> getColumnInfo(DataTable<?> table, List<?> rows) {
        Class<?> rowClass;
        ArrayList<ColumnInfo> columns = new ArrayList<ColumnInfo>();
        if (!rows.isEmpty()) {
            rowClass = rows.get(0).getClass();
        } else {
            try {
                rowClass = Class.forName(table.getClass().getName() + "$Row");
            }
            catch (ClassNotFoundException e) {
                return columns;
            }
        }
        for (Field field : rowClass.getDeclaredFields()) {
            Column columnAnnotation = field.getAnnotation(Column.class);
            if (columnAnnotation == null) continue;
            columns.add(new ColumnInfo(columnAnnotation.displayName(), columnAnnotation.description()));
        }
        return columns;
    }

    private @Nullable String getCsvContentForFile(String filename, ExecutionContext ctx) {
        Map allTables = (Map)ctx.getMessage("org.openrewrite.dataTables");
        if (allTables == null) {
            return null;
        }
        for (Map.Entry entry : allTables.entrySet()) {
            String expectedFilename;
            DataTable table = (DataTable)entry.getKey();
            String tableFqn = table.getClass().getName();
            if (!this.dataTables.contains(tableFqn) || !(expectedFilename = this.tableToFilename(tableFqn)).equals(filename)) continue;
            return this.exportToCsv(table, (List)entry.getValue());
        }
        return null;
    }

    private String tableToFilename(String tableFqn) {
        String simpleName = tableFqn.substring(tableFqn.lastIndexOf(46) + 1);
        return this.toKebabCase(simpleName) + ".csv";
    }

    private String toKebabCase(String input) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (Character.isUpperCase(c)) {
                if (i > 0 && result.length() > 0 && result.charAt(result.length() - 1) != '-') {
                    result.append('-');
                }
                result.append(Character.toLowerCase(c));
                continue;
            }
            if (c == ' ' || c == '_') {
                if (result.length() <= 0 || result.charAt(result.length() - 1) == '-') continue;
                result.append('-');
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    private String exportToCsv(DataTable<?> table, List<?> rows) {
        if (rows.isEmpty()) {
            return this.getHeadersFromTable(table);
        }
        Class<?> rowClass = rows.get(0).getClass();
        List<Field> columnFields = this.getColumnFields(rowClass);
        StringWriter stringWriter = new StringWriter();
        CsvWriter writer = new CsvWriter((Writer)stringWriter, new CsvWriterSettings());
        String[] headers = (String[])columnFields.stream().map(f -> f.getAnnotation(Column.class).displayName()).toArray(String[]::new);
        writer.writeHeaders(headers);
        for (Object row : rows) {
            String[] values = new String[columnFields.size()];
            for (int i = 0; i < columnFields.size(); ++i) {
                Field field = columnFields.get(i);
                try {
                    field.setAccessible(true);
                    Object value = field.get(row);
                    values[i] = value == null ? "" : value.toString();
                    continue;
                }
                catch (IllegalAccessException e) {
                    values[i] = "";
                }
            }
            writer.writeRow((Object[])values);
        }
        writer.close();
        return stringWriter.toString();
    }

    private String getHeadersFromTable(DataTable<?> table) {
        try {
            Class<?> rowClass = Class.forName(table.getClass().getName() + "$Row");
            List<Field> columnFields = this.getColumnFields(rowClass);
            StringWriter stringWriter = new StringWriter();
            CsvWriter writer = new CsvWriter((Writer)stringWriter, new CsvWriterSettings());
            String[] headers = (String[])columnFields.stream().map(f -> f.getAnnotation(Column.class).displayName()).toArray(String[]::new);
            writer.writeHeaders(headers);
            writer.close();
            return stringWriter.toString();
        }
        catch (ClassNotFoundException e) {
            return "";
        }
    }

    private List<Field> getColumnFields(Class<?> rowClass) {
        ArrayList<Field> columnFields = new ArrayList<Field>();
        for (Field field : rowClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Column.class)) continue;
            columnFields.add(field);
        }
        return columnFields;
    }

    @Generated
    public ExportContext(String displayName, String shortDescription, String longDescription, List<String> dataTables) {
        this.displayName = displayName;
        this.shortDescription = shortDescription;
        this.longDescription = longDescription;
        this.dataTables = dataTables;
    }

    @Generated
    public String getShortDescription() {
        return this.shortDescription;
    }

    @Generated
    public String getLongDescription() {
        return this.longDescription;
    }

    @Generated
    public List<String> getDataTables() {
        return this.dataTables;
    }

    @Generated
    public String toString() {
        return "ExportContext(displayName=" + this.getDisplayName() + ", shortDescription=" + this.getShortDescription() + ", longDescription=" + this.getLongDescription() + ", dataTables=" + this.getDataTables() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExportContext)) {
            return false;
        }
        ExportContext other = (ExportContext)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$shortDescription = this.getShortDescription();
        String other$shortDescription = other.getShortDescription();
        if (this$shortDescription == null ? other$shortDescription != null : !this$shortDescription.equals(other$shortDescription)) {
            return false;
        }
        String this$longDescription = this.getLongDescription();
        String other$longDescription = other.getLongDescription();
        if (this$longDescription == null ? other$longDescription != null : !this$longDescription.equals(other$longDescription)) {
            return false;
        }
        List<String> this$dataTables = this.getDataTables();
        List<String> other$dataTables = other.getDataTables();
        return !(this$dataTables == null ? other$dataTables != null : !((Object)this$dataTables).equals(other$dataTables));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ExportContext;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $shortDescription = this.getShortDescription();
        result = result * 59 + ($shortDescription == null ? 43 : $shortDescription.hashCode());
        String $longDescription = this.getLongDescription();
        result = result * 59 + ($longDescription == null ? 43 : $longDescription.hashCode());
        List<String> $dataTables = this.getDataTables();
        result = result * 59 + ($dataTables == null ? 43 : ((Object)$dataTables).hashCode());
        return result;
    }

    public static final class Accumulator {
        private final Set<Path> existingContextPaths;

        @Generated
        public Accumulator(Set<Path> existingContextPaths) {
            this.existingContextPaths = existingContextPaths;
        }

        @Generated
        public Set<Path> getExistingContextPaths() {
            return this.existingContextPaths;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Accumulator)) {
                return false;
            }
            Accumulator other = (Accumulator)o;
            Set<Path> this$existingContextPaths = this.getExistingContextPaths();
            Set<Path> other$existingContextPaths = other.getExistingContextPaths();
            return !(this$existingContextPaths == null ? other$existingContextPaths != null : !((Object)this$existingContextPaths).equals(other$existingContextPaths));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Set<Path> $existingContextPaths = this.getExistingContextPaths();
            result = result * 59 + ($existingContextPaths == null ? 43 : ((Object)$existingContextPaths).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ExportContext.Accumulator(existingContextPaths=" + this.getExistingContextPaths() + ")";
        }
    }

    private static final class DataTableInfo {
        private final String displayName;
        private final String description;
        private final String filename;
        private final List<ColumnInfo> columns;

        @Generated
        public DataTableInfo(String displayName, String description, String filename, List<ColumnInfo> columns) {
            this.displayName = displayName;
            this.description = description;
            this.filename = filename;
            this.columns = columns;
        }

        @Generated
        public String getDisplayName() {
            return this.displayName;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public String getFilename() {
            return this.filename;
        }

        @Generated
        public List<ColumnInfo> getColumns() {
            return this.columns;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DataTableInfo)) {
                return false;
            }
            DataTableInfo other = (DataTableInfo)o;
            String this$displayName = this.getDisplayName();
            String other$displayName = other.getDisplayName();
            if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            String this$filename = this.getFilename();
            String other$filename = other.getFilename();
            if (this$filename == null ? other$filename != null : !this$filename.equals(other$filename)) {
                return false;
            }
            List<ColumnInfo> this$columns = this.getColumns();
            List<ColumnInfo> other$columns = other.getColumns();
            return !(this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $displayName = this.getDisplayName();
            result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            String $filename = this.getFilename();
            result = result * 59 + ($filename == null ? 43 : $filename.hashCode());
            List<ColumnInfo> $columns = this.getColumns();
            result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ExportContext.DataTableInfo(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ", filename=" + this.getFilename() + ", columns=" + this.getColumns() + ")";
        }
    }

    private static final class ColumnInfo {
        private final String displayName;
        private final String description;

        @Generated
        public ColumnInfo(String displayName, String description) {
            this.displayName = displayName;
            this.description = description;
        }

        @Generated
        public String getDisplayName() {
            return this.displayName;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ColumnInfo)) {
                return false;
            }
            ColumnInfo other = (ColumnInfo)o;
            String this$displayName = this.getDisplayName();
            String other$displayName = other.getDisplayName();
            if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            return !(this$description == null ? other$description != null : !this$description.equals(other$description));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $displayName = this.getDisplayName();
            result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ExportContext.ColumnInfo(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
        }
    }
}

