/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.util;

import java.util.List;
import java.util.StringJoiner;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class MigrateCollectionsUnmodifiableSet
extends Recipe {
    private static final MethodMatcher UNMODIFIABLE_SET = new MethodMatcher("java.util.Collections unmodifiableSet(java.util.Set)", true);
    private static final MethodMatcher ARRAYS_AS_LIST = new MethodMatcher("java.util.Arrays asList(..)", true);
    final String displayName = "Prefer `Set.of(..)`";
    final String description = "Prefer `Set.Of(..)` instead of using `unmodifiableSet(java.util.Set(java.util.Arrays asList(<args>)))` in Java 9 or higher.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        TreeVisitor check = Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesJavaVersion(9), new UsesMethod(UNMODIFIABLE_SET)});
        return Preconditions.check((TreeVisitor)check, (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.NewClass newSet;
                J.MethodInvocation m = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
                if (UNMODIFIABLE_SET.matches((MethodCall)method) && m.getArguments().get(0) instanceof J.NewClass && (newSet = (J.NewClass)m.getArguments().get(0)).getArguments().get(0) instanceof J.MethodInvocation && ARRAYS_AS_LIST.matches((Expression)newSet.getArguments().get(0))) {
                    this.maybeRemoveImport("java.util.Collections");
                    this.maybeRemoveImport("java.util.Arrays");
                    this.maybeAddImport("java.util.Set");
                    StringJoiner setOf = new StringJoiner(", ", "Set.of(", ")");
                    List args = ((J.MethodInvocation)newSet.getArguments().get(0)).getArguments();
                    args.forEach(o -> setOf.add("#{any()}"));
                    return JavaTemplate.builder((String)setOf.toString()).contextSensitive().imports(new String[]{"java.util.Set"}).build().apply(this.updateCursor((Tree)m), m.getCoordinates().replace(), args.toArray());
                }
                return m;
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

