/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.lang.var;

import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.JavaVarKeyword;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;

public class UseVarForTypeCast
extends Recipe {
    final String displayName = "Use `var` for variables initialized with type casts";
    final String description = "Apply local variable type inference `var` to variables that are initialized by a cast expression where the cast type matches the declared variable type. This removes the redundant type duplication. For example, `String s = (String) obj;` becomes `var s = (String) obj;`.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesJavaVersion(10), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations variableDeclarations, ExecutionContext ctx) {
                J.VariableDeclarations vd = super.visitVariableDeclarations(variableDeclarations, (Object)ctx);
                if (this.usesVar(vd)) {
                    return vd;
                }
                J.TypeCast typeCast = this.getSingleTypeCastInitializer(vd);
                if (typeCast != null && typeCast.getType() != null && TypeUtils.isOfType((JavaType)typeCast.getType(), (JavaType)vd.getType()) && this.isInsideMethod(this.getCursor())) {
                    return this.transformToVar(vd, typeCast);
                }
                return vd;
            }

            private boolean usesVar(J.VariableDeclarations vd) {
                TypeTree typeExpression = vd.getTypeExpression();
                return typeExpression instanceof J.Identifier && "var".equals(((J.Identifier)typeExpression).getSimpleName());
            }

            private // Could not load outer class - annotation placement on inner may be incorrect
             @Nullable J.TypeCast getSingleTypeCastInitializer(J.VariableDeclarations vd) {
                if (vd.getVariables().size() != 1) {
                    return null;
                }
                Expression initializer = ((J.VariableDeclarations.NamedVariable)vd.getVariables().get(0)).getInitializer();
                if (initializer != null && (initializer = initializer.unwrap()) instanceof J.TypeCast) {
                    return (J.TypeCast)initializer;
                }
                return null;
            }

            private boolean isInsideMethod(Cursor cursor) {
                return cursor.dropParentUntil(p -> p instanceof J.MethodDeclaration || p instanceof J.ClassDeclaration || "root".equals(p)).getValue() instanceof J.MethodDeclaration;
            }

            private J.VariableDeclarations transformToVar(J.VariableDeclarations vd, J.TypeCast typeCast) {
                List variables = ListUtils.mapFirst((List)vd.getVariables(), it -> {
                    JavaType.Variable variableType = it.getVariableType() == null ? null : it.getVariableType().withOwner(null);
                    return it.withName(it.getName().withType(typeCast.getType()).withFieldType(variableType)).withVariableType(variableType);
                });
                J.Identifier typeExpression = new J.Identifier(Tree.randomId(), vd.getTypeExpression() == null ? Space.EMPTY : vd.getTypeExpression().getPrefix(), Markers.build(Collections.singleton(JavaVarKeyword.build())), Collections.emptyList(), "var", typeCast.getType(), null);
                return vd.withVariables(variables).withTypeExpression((TypeTree)typeExpression);
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

