/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.javax;

import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.RemoveAnnotation;
import org.openrewrite.java.search.FindAnnotations;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public final class RemoveTemporalAnnotation
extends Recipe {
    private final String displayName = "Remove the `@Temporal` annotation for some `java.sql` attributes";
    private final String description = "OpenJPA persists the fields of attributes of type `java.sql.Date`, `java.sql.Time`, or `java.sql.Timestamp` that have a `javax.persistence.Temporal` annotation, whereas EclipseLink throws an exception. Remove the `@Temporal` annotation so the behavior in EclipseLink will match the behavior in OpenJPA.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final Pattern temporalPattern = Pattern.compile(".*TemporalType\\.(TIMESTAMP|DATE|TIME)");
        String JAVA_SQL_TIMESTAMP = "java.sql.Timestamp";
        String JAVA_SQL_TIME = "java.sql.Time";
        String JAVA_SQL_DATE = "java.sql.Date";
        final Set javaSqlDateTimeTypes = Stream.of("java.sql.Timestamp", "java.sql.Time", "java.sql.Date").collect(Collectors.toSet());
        final Map<String, String> doNotRemove = Stream.of({"DATE", "java.sql.Timestamp"}, {"TIME", "java.sql.Timestamp"}, {"TIMESTAMP", "java.sql.Date"}).collect(Collectors.toMap(data -> data[0], data -> data[1]));
        return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("javax.persistence.Temporal", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.sql.Date", Boolean.valueOf(true)), new UsesType("java.sql.Time", Boolean.valueOf(true)), new UsesType("java.sql.Timestamp", Boolean.valueOf(true))})}), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext ctx) {
                String varClass = multiVariable.getType().toString();
                Set temporalAnnos = FindAnnotations.find((J)multiVariable, (String)"javax.persistence.Temporal");
                if (temporalAnnos.isEmpty() || !javaSqlDateTimeTypes.contains(varClass)) {
                    return multiVariable;
                }
                J.Annotation temporal = (J.Annotation)temporalAnnos.iterator().next();
                String temporalArg = ((Expression)temporal.getArguments().iterator().next()).toString();
                Matcher temporalMatch = temporalPattern.matcher(temporalArg);
                if (!temporalMatch.find()) {
                    return multiVariable;
                }
                String temporalType = temporalMatch.group(1);
                if (((String)doNotRemove.get(temporalType)).equals(varClass)) {
                    return multiVariable;
                }
                return (J.VariableDeclarations)new RemoveAnnotation("javax.persistence.Temporal").getVisitor().visit((Tree)multiVariable, (Object)ctx);
            }
        });
    }

    @Generated
    public RemoveTemporalAnnotation() {
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "RemoveTemporalAnnotation(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveTemporalAnnotation)) {
            return false;
        }
        RemoveTemporalAnnotation other = (RemoveTemporalAnnotation)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RemoveTemporalAnnotation;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

