/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.io;

import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.DeclaresType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.SearchResult;

public final class AddInputStreamBulkReadMethod
extends Recipe {
    private static final String MARKER_MESSAGE = "Missing bulk read method may cause significant performance degradation";
    private static final String JAVA_IO_INPUT_STREAM = "java.io.InputStream";
    private final String displayName = "Add bulk read method to `InputStream` implementations";
    private final String description = "Adds a `read(byte[], int, int)` method to `InputStream` subclasses that only override the single-byte `read()` method. Java's default `InputStream.read(byte[], int, int)` implementation calls the single-byte `read()` method in a loop, which can cause severe performance degradation (up to 350x slower) for bulk reads. This recipe detects `InputStream` implementations that delegate to another stream and adds the missing bulk read method to delegate bulk reads as well.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new DeclaresType(JAVA_IO_INPUT_STREAM, true), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
                if (cd.getExtends() == null || !TypeUtils.isAssignableTo((String)AddInputStreamBulkReadMethod.JAVA_IO_INPUT_STREAM, (JavaType)cd.getType())) {
                    return cd;
                }
                if (TypeUtils.isAssignableTo((String)"java.io.FilterInputStream", (JavaType)cd.getType())) {
                    return cd;
                }
                return this.processInputStreamClass(cd, cd.getBody());
            }

            public J.NewClass visitNewClass(J.NewClass newClass, ExecutionContext ctx) {
                J.NewClass nc = super.visitNewClass(newClass, (Object)ctx);
                if (nc.getBody() == null) {
                    return nc;
                }
                if (!TypeUtils.isAssignableTo((String)AddInputStreamBulkReadMethod.JAVA_IO_INPUT_STREAM, (JavaType)nc.getType())) {
                    return nc;
                }
                if (TypeUtils.isAssignableTo((String)"java.io.FilterInputStream", (JavaType)nc.getType())) {
                    return nc;
                }
                return this.processInputStreamClass(nc, nc.getBody());
            }

            private <T extends J> T processInputStreamClass(T tree, J.Block body) {
                AnalysisResult result = this.analyzeClass(body.getStatements());
                if (result == null || result.isHasBulkRead()) {
                    return tree;
                }
                if (result.getDelegate() == null || result.isComplex()) {
                    return (T)((J)SearchResult.found(tree, (String)AddInputStreamBulkReadMethod.MARKER_MESSAGE));
                }
                Statement bulkMethod = this.createBulkReadMethod(result.getDelegate(), result.isHasNullCheck(), result.isUsesIfStyle(), body);
                J.Block newBody = body.withStatements(ListUtils.flatMap((List)body.getStatements(), stmt -> stmt == result.getReadMethod() ? Arrays.asList(stmt, bulkMethod) : stmt));
                if (tree instanceof J.ClassDeclaration) {
                    return (T)((J.ClassDeclaration)tree).withBody(newBody);
                }
                if (tree instanceof J.NewClass) {
                    return (T)((J.NewClass)tree).withBody(newBody);
                }
                return tree;
            }

            private @Nullable AnalysisResult analyzeClass(List<Statement> statements) {
                J.MethodDeclaration readMethod = null;
                boolean hasBulkRead = false;
                for (Statement stmt : statements) {
                    J.MethodDeclaration method;
                    if (!(stmt instanceof J.MethodDeclaration) || !"read".equals((method = (J.MethodDeclaration)stmt).getSimpleName())) continue;
                    if (method.getParameters().isEmpty() || method.getParameters().size() == 1 && method.getParameters().get(0) instanceof J.Empty) {
                        readMethod = method;
                        continue;
                    }
                    if (method.getParameters().size() != 3) continue;
                    hasBulkRead = true;
                }
                if (readMethod == null) {
                    return null;
                }
                boolean isComplex = this.isComplexBody(readMethod);
                String delegate = isComplex ? this.findAnyDelegate(readMethod) : this.findDelegate(readMethod);
                String nullCheckVar = this.findNullCheckVariable(readMethod);
                boolean hasNullCheck = nullCheckVar != null && nullCheckVar.equals(delegate);
                List readMethodStatements = readMethod.getBody() != null ? readMethod.getBody().getStatements() : Collections.emptyList();
                boolean usesIfStyle = readMethodStatements.size() == 2 && readMethodStatements.get(0) instanceof J.If;
                return new AnalysisResult(readMethod, hasBulkRead, delegate, hasNullCheck, usesIfStyle, isComplex);
            }

            private boolean isComplexBody(J.MethodDeclaration method) {
                if (method.getBody() == null) {
                    return true;
                }
                List statements = method.getBody().getStatements();
                if (statements.size() == 1) {
                    return !this.isSimpleReturnStatement((Statement)statements.get(0));
                }
                if (statements.size() == 2) {
                    return !this.isNullCheckIfPattern((Statement)statements.get(0), (Statement)statements.get(1));
                }
                return true;
            }

            private boolean isSimpleReturnStatement(Statement stmt) {
                if (!(stmt instanceof J.Return)) {
                    return false;
                }
                J.Return ret = (J.Return)stmt;
                Expression expr = ret.getExpression();
                if (expr == null) {
                    return false;
                }
                if (expr instanceof J.Ternary) {
                    J.Ternary ternary = (J.Ternary)expr;
                    if (!this.isSimpleNullCheck(ternary.getCondition())) {
                        return false;
                    }
                    if (!(ternary.getTruePart() instanceof J.Literal) && !(ternary.getTruePart() instanceof J.Unary)) {
                        return false;
                    }
                    expr = ternary.getFalsePart();
                }
                return this.isSimpleReadInvocation(expr);
            }

            private boolean isNullCheckIfPattern(Statement first, Statement second) {
                if (!(first instanceof J.If)) {
                    return false;
                }
                J.If ifStmt = (J.If)first;
                if (!this.isSimpleNullCheck((Expression)ifStmt.getIfCondition().getTree())) {
                    return false;
                }
                Statement thenStmt = ifStmt.getThenPart();
                if (thenStmt instanceof J.Block) {
                    List thenStatements = ((J.Block)thenStmt).getStatements();
                    if (thenStatements.size() != 1) {
                        return false;
                    }
                    thenStmt = (Statement)thenStatements.get(0);
                }
                if (!(thenStmt instanceof J.Return)) {
                    return false;
                }
                J.Return thenReturn = (J.Return)thenStmt;
                if (!(thenReturn.getExpression() instanceof J.Literal) && !(thenReturn.getExpression() instanceof J.Unary)) {
                    return false;
                }
                if (ifStmt.getElsePart() != null) {
                    return false;
                }
                if (!(second instanceof J.Return)) {
                    return false;
                }
                J.Return ret = (J.Return)second;
                return this.isSimpleReadInvocation(ret.getExpression());
            }

            private boolean isSimpleReadInvocation(@Nullable Expression expr) {
                if (!(expr instanceof J.MethodInvocation)) {
                    return false;
                }
                J.MethodInvocation mi = (J.MethodInvocation)expr;
                if (!"read".equals(mi.getSimpleName())) {
                    return false;
                }
                return mi.getArguments().isEmpty() || mi.getArguments().size() == 1 && mi.getArguments().get(0) instanceof J.Empty;
            }

            private boolean isSimpleNullCheck(Expression condition) {
                if (!(condition instanceof J.Binary)) {
                    return false;
                }
                J.Binary binary = (J.Binary)condition;
                if (binary.getOperator() != J.Binary.Type.Equal) {
                    return false;
                }
                Expression left = binary.getLeft();
                Expression right = binary.getRight();
                if (J.Literal.isLiteralValue((Expression)left, null)) {
                    return right instanceof J.Identifier;
                }
                return left instanceof J.Identifier && J.Literal.isLiteralValue((Expression)right, null);
            }

            private @Nullable String findDelegate(J.MethodDeclaration method) {
                if (method.getBody() == null) {
                    return null;
                }
                for (Statement stmt : method.getBody().getStatements()) {
                    J.MethodInvocation mi;
                    if (!(stmt instanceof J.Return)) continue;
                    J.Return ret = (J.Return)stmt;
                    Expression expr = ret.getExpression();
                    if (expr instanceof J.Ternary) {
                        expr = ((J.Ternary)expr).getFalsePart();
                    }
                    if (!(expr instanceof J.MethodInvocation) || !"read".equals((mi = (J.MethodInvocation)expr).getSimpleName()) || mi.getSelect() == null || !TypeUtils.isAssignableTo((String)AddInputStreamBulkReadMethod.JAVA_IO_INPUT_STREAM, (JavaType)mi.getSelect().getType())) continue;
                    if (mi.getSelect() instanceof J.Identifier) {
                        return ((J.Identifier)mi.getSelect()).getSimpleName();
                    }
                    if (!(mi.getSelect() instanceof J.FieldAccess)) continue;
                    J.FieldAccess fa = (J.FieldAccess)mi.getSelect();
                    return fa.print(this.getCursor());
                }
                return null;
            }

            private @Nullable String findAnyDelegate(J.MethodDeclaration method) {
                if (method.getBody() == null) {
                    return null;
                }
                Set foundDelegates = (Set)new JavaIsoVisitor<Set<String>>(){

                    public J.MethodInvocation visitMethodInvocation(J.MethodInvocation mi, Set<String> foundDelegates) {
                        if ("read".equals(mi.getSimpleName()) && mi.getSelect() != null && TypeUtils.isAssignableTo((String)AddInputStreamBulkReadMethod.JAVA_IO_INPUT_STREAM, (JavaType)mi.getSelect().getType())) {
                            if (mi.getSelect() instanceof J.Identifier) {
                                foundDelegates.add(((J.Identifier)mi.getSelect()).getSimpleName());
                            } else if (mi.getSelect() instanceof J.FieldAccess) {
                                foundDelegates.add(((J.FieldAccess)mi.getSelect()).getSimpleName());
                            }
                        }
                        return super.visitMethodInvocation(mi, foundDelegates);
                    }
                }.reduce((Tree)method.getBody(), new HashSet());
                return foundDelegates.size() == 1 ? (String)foundDelegates.iterator().next() : null;
            }

            private @Nullable String findNullCheckVariable(J.MethodDeclaration method) {
                J.If ifStmt;
                String nullVar;
                if (method.getBody() == null) {
                    return null;
                }
                List statements = method.getBody().getStatements();
                if (statements.size() == 2 && statements.get(0) instanceof J.If && (nullVar = this.extractNullCheckVariable((Expression)(ifStmt = (J.If)statements.get(0)).getIfCondition().getTree())) != null) {
                    return nullVar;
                }
                for (Statement stmt : statements) {
                    J.Ternary ternary;
                    String nullVar2;
                    J.Return ret;
                    Expression expr;
                    if (!(stmt instanceof J.Return) || !((expr = (ret = (J.Return)stmt).getExpression()) instanceof J.Ternary) || (nullVar2 = this.extractNullCheckVariable((ternary = (J.Ternary)expr).getCondition())) == null) continue;
                    return nullVar2;
                }
                return null;
            }

            private @Nullable String extractNullCheckVariable(Expression condition) {
                if (!(condition instanceof J.Binary)) {
                    return null;
                }
                J.Binary binary = (J.Binary)condition;
                if (binary.getOperator() != J.Binary.Type.Equal) {
                    return null;
                }
                Expression left = binary.getLeft();
                Expression right = binary.getRight();
                if (J.Literal.isLiteralValue((Expression)right, null) && left instanceof J.Identifier) {
                    return ((J.Identifier)left).getSimpleName();
                }
                if (J.Literal.isLiteralValue((Expression)left, null) && right instanceof J.Identifier) {
                    return ((J.Identifier)right).getSimpleName();
                }
                return null;
            }

            private Statement createBulkReadMethod(String delegate, boolean hasNullCheck, boolean usesIfStyle, J.Block body) {
                String bulkReadMethod = hasNullCheck ? (usesIfStyle ? String.format("@Override\npublic int read(byte[] b, int off, int len) throws IOException {\n    if (%s == null) {\n        return -1;\n    }\n    return %s.read(b, off, len);\n}", delegate, delegate) : String.format("@Override\npublic int read(byte[] b, int off, int len) throws IOException {\n    return %s == null ? -1 : %s.read(b, off, len);\n}", delegate, delegate)) : String.format("@Override\npublic int read(byte[] b, int off, int len) throws IOException {\n    return %s.read(b, off, len);\n}", delegate);
                JavaTemplate template = JavaTemplate.builder((String)bulkReadMethod).contextSensitive().imports(new String[]{"java.io.IOException"}).build();
                J.Block newBody = body.withStatements(Collections.emptyList());
                J.Block withNewMethod = (J.Block)template.apply(new Cursor(this.getCursor(), (Object)newBody), newBody.getCoordinates().lastStatement(), new Object[0]);
                Statement bulkMethod = (Statement)withNewMethod.getStatements().get(0);
                String existingWhitespace = bulkMethod.getPrefix().getWhitespace();
                return (Statement)bulkMethod.withPrefix(Space.format((String)("\n" + existingWhitespace)));
            }
        });
    }

    @Generated
    public AddInputStreamBulkReadMethod() {
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "AddInputStreamBulkReadMethod(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddInputStreamBulkReadMethod)) {
            return false;
        }
        AddInputStreamBulkReadMethod other = (AddInputStreamBulkReadMethod)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof AddInputStreamBulkReadMethod;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    private static final class AnalysisResult {
        private final J.MethodDeclaration readMethod;
        private final boolean hasBulkRead;
        private final @Nullable String delegate;
        private final boolean hasNullCheck;
        private final boolean usesIfStyle;
        private final boolean complex;

        @ConstructorProperties(value={"readMethod", "hasBulkRead", "delegate", "hasNullCheck", "usesIfStyle", "complex"})
        @Generated
        public AnalysisResult(J.MethodDeclaration readMethod, boolean hasBulkRead, @Nullable String delegate, boolean hasNullCheck, boolean usesIfStyle, boolean complex) {
            this.readMethod = readMethod;
            this.hasBulkRead = hasBulkRead;
            this.delegate = delegate;
            this.hasNullCheck = hasNullCheck;
            this.usesIfStyle = usesIfStyle;
            this.complex = complex;
        }

        @Generated
        public J.MethodDeclaration getReadMethod() {
            return this.readMethod;
        }

        @Generated
        public boolean isHasBulkRead() {
            return this.hasBulkRead;
        }

        @Generated
        public @Nullable String getDelegate() {
            return this.delegate;
        }

        @Generated
        public boolean isHasNullCheck() {
            return this.hasNullCheck;
        }

        @Generated
        public boolean isUsesIfStyle() {
            return this.usesIfStyle;
        }

        @Generated
        public boolean isComplex() {
            return this.complex;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AnalysisResult)) {
                return false;
            }
            AnalysisResult other = (AnalysisResult)o;
            if (this.isHasBulkRead() != other.isHasBulkRead()) {
                return false;
            }
            if (this.isHasNullCheck() != other.isHasNullCheck()) {
                return false;
            }
            if (this.isUsesIfStyle() != other.isUsesIfStyle()) {
                return false;
            }
            if (this.isComplex() != other.isComplex()) {
                return false;
            }
            J.MethodDeclaration this$readMethod = this.getReadMethod();
            J.MethodDeclaration other$readMethod = other.getReadMethod();
            if (this$readMethod == null ? other$readMethod != null : !this$readMethod.equals(other$readMethod)) {
                return false;
            }
            String this$delegate = this.getDelegate();
            String other$delegate = other.getDelegate();
            return !(this$delegate == null ? other$delegate != null : !this$delegate.equals(other$delegate));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isHasBulkRead() ? 79 : 97);
            result = result * 59 + (this.isHasNullCheck() ? 79 : 97);
            result = result * 59 + (this.isUsesIfStyle() ? 79 : 97);
            result = result * 59 + (this.isComplex() ? 79 : 97);
            J.MethodDeclaration $readMethod = this.getReadMethod();
            result = result * 59 + ($readMethod == null ? 43 : $readMethod.hashCode());
            String $delegate = this.getDelegate();
            result = result * 59 + ($delegate == null ? 43 : $delegate.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "AddInputStreamBulkReadMethod.AnalysisResult(readMethod=" + this.getReadMethod() + ", hasBulkRead=" + this.isHasBulkRead() + ", delegate=" + this.getDelegate() + ", hasNullCheck=" + this.isHasNullCheck() + ", usesIfStyle=" + this.isUsesIfStyle() + ", complex=" + this.isComplex() + ")";
        }
    }
}

