/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.guava;

import java.util.Collections;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class NoGuavaMapsNewTreeMap
extends Recipe {
    private static final MethodMatcher NEW_TREE_MAP = new MethodMatcher("com.google.common.collect.Maps newTreeMap()");
    private static final MethodMatcher NEW_TREE_MAP_WITH_COMPARATOR = new MethodMatcher("com.google.common.collect.Maps newTreeMap(java.util.Comparator)");
    private static final MethodMatcher NEW_TREE_MAP_WITH_MAP = new MethodMatcher("com.google.common.collect.Maps newTreeMap(java.util.SortedMap)");
    final String displayName = "Prefer `new TreeMap<>()`";
    final String description = "Prefer the Java standard library over third-party usage of Guava in simple cases like this.";
    final Set<String> tags = Collections.singleton("guava");

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod(NEW_TREE_MAP), new UsesMethod(NEW_TREE_MAP_WITH_COMPARATOR), new UsesMethod(NEW_TREE_MAP_WITH_MAP)}), (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                if (NEW_TREE_MAP.matches((MethodCall)method)) {
                    this.maybeRemoveImport("com.google.common.collect.Maps");
                    this.maybeAddImport("java.util.TreeMap");
                    return JavaTemplate.builder((String)"new TreeMap<>()").contextSensitive().imports(new String[]{"java.util.TreeMap"}).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[0]);
                }
                if (NEW_TREE_MAP_WITH_COMPARATOR.matches((MethodCall)method)) {
                    this.maybeRemoveImport("com.google.common.collect.Maps");
                    this.maybeAddImport("java.util.TreeMap");
                    return JavaTemplate.builder((String)"new TreeMap<>(#{any(java.util.Comparator)})").contextSensitive().imports(new String[]{"java.util.TreeMap"}).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{method.getArguments().get(0)});
                }
                if (NEW_TREE_MAP_WITH_MAP.matches((MethodCall)method)) {
                    this.maybeRemoveImport("com.google.common.collect.Maps");
                    this.maybeAddImport("java.util.TreeMap");
                    return JavaTemplate.builder((String)"new TreeMap<>(#{any(java.util.Map)})").contextSensitive().imports(new String[]{"java.util.TreeMap"}).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{method.getArguments().get(0)});
                }
                return super.visitMethodInvocation(method, (Object)ctx);
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }
}

