/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.search;

import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.marker.SearchResult;

public final class FindLocaleDateTimeFormats
extends Recipe {
    private static final MethodMatcher DATE_FORMAT_GET_TIME_INSTANCE = new MethodMatcher("java.text.DateFormat getTimeInstance(..)", true);
    private static final MethodMatcher DATE_FORMAT_GET_DATE_TIME_INSTANCE = new MethodMatcher("java.text.DateFormat getDateTimeInstance(..)", true);
    private static final MethodMatcher DATE_FORMAT_GET_INSTANCE = new MethodMatcher("java.text.DateFormat getInstance(..)", true);
    private static final MethodMatcher DTF_OF_LOCALIZED_TIME = new MethodMatcher("java.time.format.DateTimeFormatter ofLocalizedTime(..)", true);
    private static final MethodMatcher DTF_OF_LOCALIZED_DATE_TIME = new MethodMatcher("java.time.format.DateTimeFormatter ofLocalizedDateTime(..)", true);
    private static final List<MethodMatcher> ALL_MATCHERS = Arrays.asList(DATE_FORMAT_GET_TIME_INSTANCE, DATE_FORMAT_GET_DATE_TIME_INSTANCE, DATE_FORMAT_GET_INSTANCE, DTF_OF_LOCALIZED_TIME, DTF_OF_LOCALIZED_DATE_TIME);
    private final String displayName = "Find locale-sensitive date/time formatting";
    private final String description = "Finds usages of locale-based date/time formatting APIs that may be affected by JDK 20+ CLDR locale data changes, where the space before AM/PM was changed from a regular space to a narrow no-break space (NNBSP).";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.text.DateFormat get*Instance(..)", true), new UsesMethod("java.time.format.DateTimeFormatter ofLocalized*Time(..)", true)}), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
                for (MethodMatcher matcher : ALL_MATCHERS) {
                    if (!matcher.matches((MethodCall)mi)) continue;
                    return (J.MethodInvocation)SearchResult.found((Tree)mi, (String)"JDK 20+ CLDR: may use NNBSP before AM/PM");
                }
                return mi;
            }
        });
    }

    @Generated
    public FindLocaleDateTimeFormats() {
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "FindLocaleDateTimeFormats(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindLocaleDateTimeFormats)) {
            return false;
        }
        FindLocaleDateTimeFormats other = (FindLocaleDateTimeFormats)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindLocaleDateTimeFormats;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

