/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.lang.var;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.migrate.lang.var.DeclarationCheck;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

public final class UseVarForObject
extends Recipe {
    private final String displayName = "Use `var` for reference-typed variables";
    private final String description = "Try to apply local variable type inference `var` to variables containing Objects where possible. This recipe will not touch variable declarations with generics or initializers containing ternary operators.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesJavaVersion(10), (TreeVisitor)new UseVarForObjectVisitor());
    }

    @Generated
    public UseVarForObject() {
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "UseVarForObject(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UseVarForObject)) {
            return false;
        }
        UseVarForObject other = (UseVarForObject)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof UseVarForObject;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    static final class UseVarForObjectVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        UseVarForObjectVisitor() {
        }

        public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations vd, ExecutionContext ctx) {
            vd = super.visitVariableDeclarations(vd, (Object)ctx);
            boolean isGeneralApplicable = DeclarationCheck.isVarApplicable(this.getCursor(), vd);
            if (!isGeneralApplicable) {
                return vd;
            }
            boolean isPrimitive = DeclarationCheck.isPrimitive(vd);
            boolean usesGenerics = DeclarationCheck.useGenerics(vd);
            boolean usesTernary = DeclarationCheck.initializedByTernary(vd);
            Expression initializer = ((J.VariableDeclarations.NamedVariable)vd.getVariables().get(0)).getInitializer();
            boolean usesArrayInitializer = initializer instanceof J.NewArray;
            boolean initializedByStaticMethod = DeclarationCheck.initializedByStaticMethod(initializer);
            if (isPrimitive || usesGenerics || usesTernary || usesArrayInitializer || initializedByStaticMethod) {
                return vd;
            }
            if (vd.getType() instanceof JavaType.FullyQualified) {
                this.maybeRemoveImport((JavaType.FullyQualified)vd.getType());
            }
            return DeclarationCheck.transformToVar(vd);
        }
    }
}

