/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.javax;

import java.util.List;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.TypeMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;

public final class HttpSessionInvalidate
extends Recipe {
    private final String displayName = "Use HttpServletRequest `logout` method for programmatic security logout in Servlet 3.0";
    private final String description = "Do not rely on HttpSession `invalidate` method for programmatic security logout. Add the HttpServletRequest `logout` method which was introduced in Java EE 6 as part of the Servlet 3.0 specification.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final MethodMatcher invalidateMethodMatcher = new MethodMatcher("javax.servlet.http.HttpSession invalidate()", false);
        final TypeMatcher httpServletRequestTypeMatcher = new TypeMatcher("javax.servlet.http.HttpServletRequest");
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod(invalidateMethodMatcher), new UsesType("javax.servlet.http.HttpServletRequest", Boolean.valueOf(true))}), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                if (invalidateMethodMatcher.matches((MethodCall)method)) {
                    J.MethodDeclaration parentMethod = (J.MethodDeclaration)this.getCursor().firstEnclosing(J.MethodDeclaration.class);
                    Integer servletReqParamIndex = this.getServletRequestIndex(parentMethod);
                    if (servletReqParamIndex == null) {
                        return method;
                    }
                    J.VariableDeclarations httpServletRequestDeclaration = (J.VariableDeclarations)parentMethod.getParameters().get(servletReqParamIndex);
                    JavaTemplate logoutTemplate = JavaTemplate.builder((String)"#{any(javax.servlet.http.HttpServletRequest)}.logout()").imports(new String[]{"javax.servlet.http.HttpServletRequest"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"javax.servlet-3.0"})).build();
                    method = (J.MethodInvocation)logoutTemplate.apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{((J.VariableDeclarations.NamedVariable)httpServletRequestDeclaration.getVariables().get(0)).getName()});
                }
                return super.visitMethodInvocation(method, (Object)ctx);
            }

            private @Nullable Integer getServletRequestIndex(J.MethodDeclaration parentMethod) {
                List params = parentMethod.getMethodType().getParameterTypes();
                for (int i = 0; i < params.size(); ++i) {
                    if (!httpServletRequestTypeMatcher.matches((JavaType)params.get(i))) continue;
                    return i;
                }
                return null;
            }
        });
    }

    @Generated
    public HttpSessionInvalidate() {
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "HttpSessionInvalidate(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpSessionInvalidate)) {
            return false;
        }
        HttpSessionInvalidate other = (HttpSessionInvalidate)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof HttpSessionInvalidate;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

