/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.javax;

import java.util.Comparator;
import java.util.regex.Pattern;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;

public final class AddTransientAnnotationToCollections
extends Recipe {
    private final String displayName = "Unannotated collection attributes require a Transient annotation";
    private final String description = "In OpenJPA, attributes that inherit from the `java.util.Collection<E>` interface are not a default persistent type, so these attributes are not persisted unless they are annotated. EclipseLink has a different default behavior and attempts to persist these attributes to the database. To keep the OpenJPA behavior of ignoring unannotated collection attributes, add the `javax.persistence.Transient` annotation to these attributes in EclipseLink.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final Pattern collection = Pattern.compile("java.util.Collection");
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("javax.persistence.Entity", Boolean.valueOf(true)), new UsesType("javax.persistence.MappedSuperclass", Boolean.valueOf(true)), new UsesType("javax.persistence.Embeddable", Boolean.valueOf(true))}), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext ctx) {
                if (!multiVariable.getType().isAssignableFrom(collection)) {
                    return multiVariable;
                }
                if (multiVariable.getLeadingAnnotations().stream().anyMatch(anno -> anno.getType().toString().contains("javax.persistence"))) {
                    return multiVariable;
                }
                this.maybeAddImport("javax.persistence.Transient");
                return (J.VariableDeclarations)JavaTemplate.builder((String)"@Transient").contextSensitive().javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"javax.persistence-api-2.2"})).imports(new String[]{"javax.persistence.Transient"}).build().apply(this.getCursor(), multiVariable.getCoordinates().addAnnotation(Comparator.comparing(J.Annotation::getSimpleName)), new Object[0]);
            }
        });
    }

    @Generated
    public AddTransientAnnotationToCollections() {
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "AddTransientAnnotationToCollections(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddTransientAnnotationToCollections)) {
            return false;
        }
        AddTransientAnnotationToCollections other = (AddTransientAnnotationToCollections)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AddTransientAnnotationToCollections;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

