/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.io;

import java.util.Collections;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;

public final class ReplaceFileInOrOutputStreamFinalizeWithClose
extends Recipe {
    private static final String JAVA_IO_FILE_INPUT_STREAM = "java.io.FileInputStream";
    private static final String JAVA_IO_FILE_OUTPUT_STREAM = "java.io.FileOutputStream";
    private static final MethodMatcher METHOD_MATCHER = new MethodMatcher("java.lang.Object finalize()");
    private final String displayName = "Replace invocations of `finalize()` on `FileInputStream` and `FileOutputStream` with `close()`";
    private final String description = "Replace invocations of the deprecated `finalize()` method on `FileInputStream` and `FileOutputStream` with `close()`.";
    private final Set<String> tags = Collections.singleton("JDK-8212050");

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesJavaVersion(9, 11), new UsesMethod(METHOD_MATCHER)}), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
                if (METHOD_MATCHER.matches((MethodCall)mi)) {
                    JavaType type;
                    Expression select = mi.getSelect();
                    Object object = type = select != null ? select.getType() : ((J.ClassDeclaration)this.getCursor().firstEnclosingOrThrow(J.ClassDeclaration.class)).getType();
                    if (TypeUtils.isAssignableTo((String)ReplaceFileInOrOutputStreamFinalizeWithClose.JAVA_IO_FILE_INPUT_STREAM, (JavaType)type) || TypeUtils.isAssignableTo((String)ReplaceFileInOrOutputStreamFinalizeWithClose.JAVA_IO_FILE_OUTPUT_STREAM, (JavaType)type)) {
                        return mi.withName(mi.getName().withSimpleName("close"));
                    }
                }
                return mi;
            }
        });
    }

    @Generated
    public ReplaceFileInOrOutputStreamFinalizeWithClose() {
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ReplaceFileInOrOutputStreamFinalizeWithClose(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ", tags=" + this.getTags() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReplaceFileInOrOutputStreamFinalizeWithClose)) {
            return false;
        }
        ReplaceFileInOrOutputStreamFinalizeWithClose other = (ReplaceFileInOrOutputStreamFinalizeWithClose)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Set<String> this$tags = this.getTags();
        Set<String> other$tags = other.getTags();
        return !(this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ReplaceFileInOrOutputStreamFinalizeWithClose;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Set<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        return result;
    }
}

