/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.guava;

import java.util.Collections;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class NoGuavaAtomicsNewReference
extends Recipe {
    private static final MethodMatcher NEW_ATOMIC_REFERENCE = new MethodMatcher("com.google.common.util.concurrent.Atomics newReference(..)");
    final String displayName = "Prefer `new AtomicReference<>()`";
    final String description = "Prefer the Java standard library over third-party usage of Guava in simple cases like this.";
    final Set<String> tags = Collections.singleton("guava");

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(NEW_ATOMIC_REFERENCE), (TreeVisitor)new JavaVisitor<ExecutionContext>(){
            private final JavaTemplate newAtomicReference = JavaTemplate.builder((String)"new AtomicReference<>()").imports(new String[]{"java.util.concurrent.atomic.AtomicReference"}).build();

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                if (NEW_ATOMIC_REFERENCE.matches((MethodCall)method)) {
                    this.maybeRemoveImport("com.google.common.util.concurrent.Atomics");
                    this.maybeAddImport("java.util.concurrent.atomic.AtomicReference");
                    return ((J.NewClass)this.newAtomicReference.apply(this.getCursor(), method.getCoordinates().replace(), new Object[0])).withArguments(method.getArguments());
                }
                return super.visitMethodInvocation(method, (Object)ctx);
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }
}

