/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FindSourceFiles;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.json.JsonIsoVisitor;
import org.openrewrite.json.tree.Json;
import org.openrewrite.json.tree.JsonRightPadded;
import org.openrewrite.json.tree.JsonValue;
import org.openrewrite.marker.Markers;
import org.openrewrite.marker.SearchResult;

public final class MigrateGraalVMResourceConfig
extends Recipe {
    private final String displayName = "Migrate GraalVM resource-config.json to glob patterns";
    private final String description = "Migrates GraalVM native-image resource-config.json files from the legacy regex pattern format (JDK 21 and earlier) to the new glob pattern format (JDK 23+). Converts `pattern` entries to `glob` entries and restructures the format. Note: `excludes` are no longer supported in the new format and will be removed.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((Recipe)new FindSourceFiles("**/resource-config.json"), (TreeVisitor)new ResourceConfigVisitor());
    }

    @Generated
    public MigrateGraalVMResourceConfig() {
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "MigrateGraalVMResourceConfig(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MigrateGraalVMResourceConfig)) {
            return false;
        }
        MigrateGraalVMResourceConfig other = (MigrateGraalVMResourceConfig)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof MigrateGraalVMResourceConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    private static class ResourceConfigVisitor
    extends JsonIsoVisitor<ExecutionContext> {
        private ResourceConfigVisitor() {
        }

        public Json.Document visitDocument(Json.Document document, ExecutionContext ctx) {
            Json.Document doc = super.visitDocument(document, (Object)ctx);
            JsonValue value = doc.getValue();
            if (!(value instanceof Json.JsonObject)) {
                return doc;
            }
            Json.JsonObject root = (Json.JsonObject)value;
            Json.Member resourcesMember = ResourceConfigVisitor.findMember(root, "resources");
            if (resourcesMember == null) {
                return doc;
            }
            if (resourcesMember.getValue() instanceof Json.Array) {
                return doc;
            }
            if (!(resourcesMember.getValue() instanceof Json.JsonObject)) {
                return doc;
            }
            Json.JsonObject resourcesObj = (Json.JsonObject)resourcesMember.getValue();
            Json.Member includesMember = ResourceConfigVisitor.findMember(resourcesObj, "includes");
            Json.Member excludesMember = ResourceConfigVisitor.findMember(resourcesObj, "excludes");
            if (includesMember == null && excludesMember == null) {
                return doc;
            }
            ArrayList<JsonRightPadded> newResourceEntries = new ArrayList<JsonRightPadded>();
            boolean hasUnconvertiblePatterns = false;
            if (includesMember != null && includesMember.getValue() instanceof Json.Array) {
                Json.Array includesArray = (Json.Array)includesMember.getValue();
                for (JsonRightPadded paddedEntry : includesArray.getPadding().getValues()) {
                    Json.JsonObject entryObj;
                    ConvertedEntry converted;
                    JsonValue entry = (JsonValue)paddedEntry.getElement();
                    if (!(entry instanceof Json.JsonObject) || (converted = this.convertPatternEntry(entryObj = (Json.JsonObject)entry)) == null) continue;
                    newResourceEntries.add(paddedEntry.withElement((Json)converted.entry));
                    if (!converted.hasWarning) continue;
                    hasUnconvertiblePatterns = true;
                }
            }
            Json.Array newResourcesArray = new Json.Array(Tree.randomId(), resourcesObj.getPrefix(), Markers.EMPTY, newResourceEntries);
            Json.Member newResourcesMember = resourcesMember.withValue((JsonValue)newResourcesArray);
            Json.JsonObject newRoot = root.getPadding().withMembers(ListUtils.map((List)root.getPadding().getMembers(), paddedMember -> paddedMember.getElement() == resourcesMember ? paddedMember.withElement((Json)newResourcesMember) : paddedMember));
            doc = doc.withValue((JsonValue)newRoot);
            if (hasUnconvertiblePatterns) {
                doc = (Json.Document)SearchResult.found((Tree)doc, (String)"Some patterns could not be automatically converted to glob format");
            }
            return doc;
        }

        private @Nullable ConvertedEntry convertPatternEntry(Json.JsonObject entryObj) {
            Json.Member patternMember = ResourceConfigVisitor.findMember(entryObj, "pattern");
            if (patternMember == null) {
                return new ConvertedEntry(entryObj, false);
            }
            String patternValue = ResourceConfigVisitor.getLiteralValue(patternMember.getValue());
            if (patternValue == null) {
                return new ConvertedEntry(entryObj, false);
            }
            ConversionResult result = ResourceConfigVisitor.convertRegexToGlob(patternValue);
            if (!result.isSuccessful()) {
                return new ConvertedEntry((Json.JsonObject)SearchResult.found((Tree)entryObj, (String)result.warningMessage), true);
            }
            Json.JsonObject newEntry = entryObj.getPadding().withMembers(ListUtils.map((List)entryObj.getPadding().getMembers(), paddedMember -> {
                Json.Member m;
                Json member = paddedMember.getElement();
                if (member instanceof Json.Member && "pattern".equals(ResourceConfigVisitor.getKeyName(m = (Json.Member)member))) {
                    return paddedMember.withElement((Json)this.createGlobMember(m, result.glob));
                }
                return paddedMember;
            }));
            return new ConvertedEntry(newEntry, false);
        }

        private Json.Member createGlobMember(Json.Member patternMember, String globValue) {
            Json.Literal newValue;
            Json.Literal newKey;
            if (patternMember.getKey() instanceof Json.Literal) {
                Json.Literal oldKey = (Json.Literal)patternMember.getKey();
                String newKeySource = oldKey.getSource().replace("pattern", "glob");
                newKey = oldKey.withSource(newKeySource);
            } else {
                newKey = new Json.Literal(Tree.randomId(), patternMember.getKey().getPrefix(), Markers.EMPTY, "\"glob\"", (Object)"glob");
            }
            if (patternMember.getValue() instanceof Json.Literal) {
                Json.Literal oldValue = (Json.Literal)patternMember.getValue();
                String newValueSource = "\"" + ResourceConfigVisitor.escapeJsonString(globValue) + "\"";
                newValue = oldValue.withSource(newValueSource).withValue((Object)globValue);
            } else {
                newValue = new Json.Literal(Tree.randomId(), patternMember.getValue().getPrefix(), Markers.EMPTY, "\"" + ResourceConfigVisitor.escapeJsonString(globValue) + "\"", (Object)globValue);
            }
            return patternMember.getPadding().withKey(patternMember.getPadding().getKey().withElement((Json)newKey)).withValue((JsonValue)newValue);
        }

        private static // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable Json.Member findMember(Json.JsonObject obj, String keyName) {
            for (JsonRightPadded paddedMember : obj.getPadding().getMembers()) {
                Json.Member member;
                if (!(paddedMember.getElement() instanceof Json.Member) || !keyName.equals(ResourceConfigVisitor.getKeyName(member = (Json.Member)paddedMember.getElement()))) continue;
                return member;
            }
            return null;
        }

        private static @Nullable String getKeyName(Json.Member member) {
            if (member.getKey() instanceof Json.Literal) {
                Object value = ((Json.Literal)member.getKey()).getValue();
                return value instanceof String ? (String)value : null;
            }
            if (member.getKey() instanceof Json.Identifier) {
                return ((Json.Identifier)member.getKey()).getName();
            }
            return null;
        }

        private static @Nullable String getLiteralValue(JsonValue value) {
            if (value instanceof Json.Literal) {
                Object v = ((Json.Literal)value).getValue();
                return v instanceof String ? (String)v : null;
            }
            return null;
        }

        private static String escapeJsonString(String s) {
            StringBuilder sb = new StringBuilder();
            block7: for (char c : s.toCharArray()) {
                switch (c) {
                    case '\"': {
                        sb.append("\\\"");
                        continue block7;
                    }
                    case '\\': {
                        sb.append("\\\\");
                        continue block7;
                    }
                    case '\n': {
                        sb.append("\\n");
                        continue block7;
                    }
                    case '\r': {
                        sb.append("\\r");
                        continue block7;
                    }
                    case '\t': {
                        sb.append("\\t");
                        continue block7;
                    }
                    default: {
                        sb.append(c);
                    }
                }
            }
            return sb.toString();
        }

        private static ConversionResult convertRegexToGlob(String regex) {
            if (StringUtils.isNullOrEmpty((String)regex)) {
                return new ConversionResult(null, "Empty pattern cannot be converted");
            }
            String unconvertibleReason = ResourceConfigVisitor.findUnconvertibleConstruct(regex);
            if (unconvertibleReason != null) {
                return new ConversionResult(null, unconvertibleReason);
            }
            String glob = regex;
            glob = glob.replace("\\\\.", "\u0000DOT\u0000");
            glob = glob.replace("\\.", "\u0000DOT\u0000");
            glob = glob.replace("[^/]*", "*");
            glob = glob.replace("[^/]+", "*");
            glob = glob.replaceAll("^\\.\\*\u0000DOT\u0000", "**/*.");
            glob = glob.replaceAll("\\.\\*$", "**");
            glob = glob.replace("/.*", "/**");
            glob = glob.replace(".*", "**");
            glob = glob.replace("\u0000DOT\u0000", ".");
            glob = glob.replace("\\/", "/");
            glob = glob.replace("\\-", "-");
            String validationError = ResourceConfigVisitor.validateGlob(glob = glob.replace("\\_", "_"));
            if (validationError != null) {
                return new ConversionResult(null, validationError);
            }
            return new ConversionResult(glob, null);
        }

        private static @Nullable String findUnconvertibleConstruct(String pattern) {
            if ((pattern.matches(".*\\[[^^/].*\\].*") || pattern.matches(".*\\[\\^[^/].*\\].*")) && !pattern.matches(".*\\[\\^/\\][*+].*") && pattern.matches(".*\\[.*\\].*")) {
                return "Pattern contains character class that cannot be converted to glob: " + pattern;
            }
            if (pattern.contains("(") && pattern.contains("|")) {
                return "Pattern contains alternation group that cannot be converted to glob: " + pattern;
            }
            if (pattern.matches(".*\\{\\d+,?\\d*}.*")) {
                return "Pattern contains bounded quantifier that cannot be converted to glob: " + pattern;
            }
            if (pattern.contains("\\d") || pattern.contains("\\D") || pattern.contains("\\w") || pattern.contains("\\W") || pattern.contains("\\s") || pattern.contains("\\S")) {
                return "Pattern contains special character class that cannot be converted to glob: " + pattern;
            }
            if (pattern.startsWith("^") || pattern.endsWith("$")) {
                return "Pattern contains anchors that cannot be converted to glob: " + pattern;
            }
            if (pattern.contains("(?=") || pattern.contains("(?!") || pattern.contains("(?<=") || pattern.contains("(?<!")) {
                return "Pattern contains lookahead/lookbehind that cannot be converted to glob: " + pattern;
            }
            if (pattern.matches(".*\\\\\\d+.*")) {
                return "Pattern contains backreference that cannot be converted to glob: " + pattern;
            }
            if (pattern.matches(".*[^\\\\]\\?.*") || pattern.startsWith("?")) {
                return "Pattern contains optional quantifier (?) that cannot be converted to glob: " + pattern;
            }
            return null;
        }

        private static @Nullable String validateGlob(String glob) {
            if (glob.isEmpty()) {
                return "Converted glob pattern is empty";
            }
            if (glob.endsWith("/")) {
                return "Glob pattern cannot end with /";
            }
            if (glob.contains("***")) {
                return "Glob pattern cannot contain more than two consecutive *";
            }
            if (glob.contains("//")) {
                return "Glob pattern cannot contain empty path segments (//)";
            }
            if (!(!glob.matches(".*\\*\\*[^/].*") && !glob.matches(".*[^/]\\*\\*.*") || glob.matches(".*\\*\\*/.*") || glob.matches(".*/\\*\\*$") || "**".equals(glob))) {
                return "Globstar (**) must be a complete path segment";
            }
            return null;
        }

        private static final class ConvertedEntry {
            final Json.JsonObject entry;
            final boolean hasWarning;

            ConvertedEntry(Json.JsonObject entry, boolean hasWarning) {
                this.entry = entry;
                this.hasWarning = hasWarning;
            }
        }

        private static final class ConversionResult {
            final @Nullable String glob;
            final @Nullable String warningMessage;

            ConversionResult(@Nullable String glob, @Nullable String warningMessage) {
                this.glob = glob;
                this.warningMessage = warningMessage;
            }

            boolean isSuccessful() {
                return this.glob != null;
            }
        }
    }
}

