/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate;

import java.util.List;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.ChangeType;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.search.FindMethods;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class IllegalArgumentExceptionToAlreadyConnectedException
extends Recipe {
    private static final String ILLEGAL_ARGUMENT_EXCEPTION = "java.lang.IllegalArgumentException";
    private static final String ALREADY_CONNECTED_EXCEPTION = "java.nio.channels.AlreadyConnectedException";
    final String displayName = "Replace `IllegalArgumentException` with `AlreadyConnectedException` in `DatagramChannel.send()` method";
    final String description = "Replace `IllegalArgumentException` with `AlreadyConnectedException` for DatagramChannel.send() to ensure compatibility with Java 11+.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final String datagramChannelSendMethodPattern = "java.nio.channels.DatagramChannel send(java.nio.ByteBuffer, java.net.SocketAddress)";
        return Preconditions.check((TreeVisitor)new UsesMethod(datagramChannelSendMethodPattern), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.Try visitTry(J.Try tryStatement, ExecutionContext ctx) {
                J.Try try_ = super.visitTry(tryStatement, (Object)ctx);
                if (FindMethods.find((J)try_, (String)datagramChannelSendMethodPattern).isEmpty()) {
                    return try_;
                }
                return try_.withCatches(ListUtils.map((List)try_.getCatches(), catch_ -> {
                    if (TypeUtils.isOfClassType((JavaType)catch_.getParameter().getType(), (String)IllegalArgumentExceptionToAlreadyConnectedException.ILLEGAL_ARGUMENT_EXCEPTION)) {
                        this.maybeAddImport(IllegalArgumentExceptionToAlreadyConnectedException.ALREADY_CONNECTED_EXCEPTION);
                        return (J.Try.Catch)new ChangeType(IllegalArgumentExceptionToAlreadyConnectedException.ILLEGAL_ARGUMENT_EXCEPTION, IllegalArgumentExceptionToAlreadyConnectedException.ALREADY_CONNECTED_EXCEPTION, Boolean.valueOf(true)).getVisitor().visit((Tree)catch_, (Object)ctx);
                    }
                    return catch_;
                }));
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

