/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.guava;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class PreferJavaUtilOptionalOrElseNull
extends Recipe {
    final String displayName = "Prefer `java.util.Optional#orElse(null)` over `com.google.common.base.Optional#orNull()`";
    final String description = "Replaces `com.google.common.base.Optional#orNull()` with `java.util.Optional#orElse(null)`.";
    final Set<String> tags = new HashSet<String>(Arrays.asList("RSPEC-S4738", "guava"));

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod("com.google.common.base.Optional orNull()"), (TreeVisitor)new PreferJavaUtilOptionalOrElseNullVisitor());
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }

    private static class PreferJavaUtilOptionalOrElseNullVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private static final MethodMatcher OPTIONAL_OR_NULL_MATCHER = new MethodMatcher("com.google.common.base.Optional orNull()");

        private PreferJavaUtilOptionalOrElseNullVisitor() {
        }

        public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
            J.CompilationUnit c = super.visitCompilationUnit(cu, (Object)ctx);
            this.maybeRemoveImport("com.google.common.base.Optional");
            this.maybeAddImport("java.util.Optional");
            return c;
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
            if (OPTIONAL_OR_NULL_MATCHER.matches((MethodCall)mi)) {
                mi = mi.withName(mi.getName().withSimpleName("orElse"));
                mi = (J.MethodInvocation)JavaTemplate.builder((String)"null").build().apply(this.updateCursor((Tree)mi), mi.getCoordinates().replaceArguments(), new Object[0]);
            }
            return mi;
        }
    }
}

