/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class RemovedSecurityManagerMethods
extends Recipe {
    final String displayName = "Replace deprecated methods in`SecurityManager`";
    final String description = "Replace `SecurityManager` methods `checkAwtEventQueueAccess()`, `checkSystemClipboardAccess()`, `checkMemberAccess()` and `checkTopLevelWindow()` deprecated in Java SE 11 by `checkPermission(new java.security.AllPermission())`.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){
            private final MethodMatcher METHOD_PATTERN_QUE = new MethodMatcher("java.lang.SecurityManager checkAwtEventQueueAccess()", false);
            private final MethodMatcher METHOD_PATTERN_CLIP = new MethodMatcher("java.lang.SecurityManager checkSystemClipboardAccess()", false);
            private final MethodMatcher METHOD_PATTERN_MEMBER = new MethodMatcher("java.lang.SecurityManager checkMemberAccess(..)", false);
            private final MethodMatcher METHOD_PATTERN_WINDOW = new MethodMatcher("java.lang.SecurityManager checkTopLevelWindow(..)", false);

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                if (this.METHOD_PATTERN_QUE.matches((MethodCall)method) || this.METHOD_PATTERN_CLIP.matches((MethodCall)method) || this.METHOD_PATTERN_MEMBER.matches((MethodCall)method) || this.METHOD_PATTERN_WINDOW.matches((MethodCall)method)) {
                    return JavaTemplate.builder((String)"checkPermission(new java.security.AllPermission())").imports(new String[]{"java.security.AllPermission"}).build().apply(this.updateCursor((Tree)method), method.getCoordinates().replaceMethod(), new Object[0]);
                }
                return method;
            }
        };
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

