/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.lang;

import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.staticanalysis.SimplifyDurationCreationUnits;

public class MigrateProcessWaitForDuration
extends Recipe {
    private static final MethodMatcher PROCESS_WAIT_FOR_MATCHER = new MethodMatcher("java.lang.Process waitFor(long, java.util.concurrent.TimeUnit)");

    public String getDisplayName() {
        return "Use `Process#waitFor(Duration)`";
    }

    public String getDescription() {
        return "Use `Process#waitFor(Duration)` instead of `Process#waitFor(long, TimeUnit)` in Java 25 or higher.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesJavaVersion(25), (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation mi = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
                if (PROCESS_WAIT_FOR_MATCHER.matches((MethodCall)mi)) {
                    Expression valueArg = (Expression)mi.getArguments().get(0);
                    Expression unitArg = (Expression)mi.getArguments().get(1);
                    String timeUnitName = this.getTimeUnitName(unitArg);
                    String durationMethod = this.getDurationMethod(timeUnitName);
                    boolean isSimpleValue = valueArg instanceof J.Literal || valueArg instanceof J.Identifier;
                    this.maybeRemoveImport("java.util.concurrent.TimeUnit");
                    this.maybeRemoveImport("java.util.concurrent.TimeUnit." + timeUnitName);
                    this.maybeAddImport("java.time.Duration");
                    this.maybeAddImport("java.time.temporal.ChronoUnit");
                    this.doAfterVisit(new SimplifyDurationCreationUnits().getVisitor());
                    if (isSimpleValue && "MICROSECONDS".equals(timeUnitName)) {
                        return JavaTemplate.builder((String)"Duration.of(#{any(long)}, ChronoUnit.MICROS)").imports(new String[]{"java.time.Duration", "java.time.temporal.ChronoUnit"}).build().apply(this.getCursor(), mi.getCoordinates().replaceArguments(), new Object[]{valueArg});
                    }
                    if (isSimpleValue && durationMethod != null) {
                        return JavaTemplate.builder((String)("Duration." + durationMethod + "(#{any(long)})")).imports(new String[]{"java.time.Duration"}).build().apply(this.getCursor(), mi.getCoordinates().replaceArguments(), new Object[]{valueArg});
                    }
                    return JavaTemplate.builder((String)"Duration.of(#{any(long)}, #{any(java.util.concurrent.TimeUnit)}.toChronoUnit())").imports(new String[]{"java.time.Duration"}).build().apply(this.getCursor(), mi.getCoordinates().replaceArguments(), new Object[]{valueArg, unitArg});
                }
                return mi;
            }

            private @Nullable String getTimeUnitName(Expression timeUnitArg) {
                if (timeUnitArg instanceof J.FieldAccess) {
                    J.FieldAccess fa = (J.FieldAccess)timeUnitArg;
                    return fa.getSimpleName();
                }
                if (timeUnitArg instanceof J.Identifier) {
                    J.Identifier id = (J.Identifier)timeUnitArg;
                    return id.getSimpleName();
                }
                return null;
            }

            private @Nullable String getDurationMethod(@Nullable String timeUnitName) {
                if (timeUnitName == null) {
                    return null;
                }
                switch (timeUnitName) {
                    case "NANOSECONDS": {
                        return "ofNanos";
                    }
                    case "MILLISECONDS": {
                        return "ofMillis";
                    }
                    case "SECONDS": {
                        return "ofSeconds";
                    }
                    case "MINUTES": {
                        return "ofMinutes";
                    }
                    case "HOURS": {
                        return "ofHours";
                    }
                    case "DAYS": {
                        return "ofDays";
                    }
                }
                return null;
            }
        });
    }
}

