/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.util;

import java.util.List;
import java.util.StringJoiner;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class MigrateCollectionsSingletonMap
extends Recipe {
    private static final MethodMatcher SINGLETON_MAP = new MethodMatcher("java.util.Collections singletonMap(..)", true);

    public String getDisplayName() {
        return "Prefer `Map.of(..)`";
    }

    public String getDescription() {
        return "Prefer `Map.of(..)` instead of using `Collections.singletonMap()` in Java 9 or higher.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesJavaVersion(9), new UsesMethod(SINGLETON_MAP)}), (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
                if (SINGLETON_MAP.matches((MethodCall)method) && this.isNotLiteralNull(m)) {
                    this.maybeRemoveImport("java.util.Collections");
                    this.maybeAddImport("java.util.Map");
                    StringJoiner mapOf = new StringJoiner(", ", "Map.of(", ")");
                    List args = m.getArguments();
                    args.forEach(o -> mapOf.add("#{any()}"));
                    return JavaTemplate.builder((String)mapOf.toString()).contextSensitive().imports(new String[]{"java.util.Map"}).build().apply(this.updateCursor((Tree)m), m.getCoordinates().replace(), m.getArguments().toArray());
                }
                return m;
            }

            private boolean isNotLiteralNull(J.MethodInvocation m) {
                return !J.Literal.isLiteralValue((Expression)((Expression)m.getArguments().get(0)), null) && !J.Literal.isLiteralValue((Expression)((Expression)m.getArguments().get(1)), null);
            }
        });
    }
}

