/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.lombok;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public class LombokOnXToOnX_
extends Recipe {
    private static final AnnotationMatcher LOMBOK_GETTER = new AnnotationMatcher("@lombok.Getter");
    private static final AnnotationMatcher LOMBOK_SETTER = new AnnotationMatcher("@lombok.Setter");
    private static final AnnotationMatcher LOMBOK_WITH = new AnnotationMatcher("@lombok.With");
    private static final AnnotationMatcher LOMBOK_WITHER = new AnnotationMatcher("@lombok.Wither");
    private static final AnnotationMatcher LOMBOK_EQUALS_AND_HASHCODE = new AnnotationMatcher("@lombok.EqualsAndHashCode");
    private static final AnnotationMatcher LOMBOK_TO_STRING = new AnnotationMatcher("@lombok.ToString");
    private static final AnnotationMatcher LOMBOK_REQUIRED_ARGS_CONSTRUCTOR = new AnnotationMatcher("@lombok.RequiredArgsConstructor");
    private static final AnnotationMatcher LOMBOK_ALL_ARGS_CONSTRUCTOR = new AnnotationMatcher("@lombok.AllArgsConstructor");
    private static final AnnotationMatcher LOMBOK_NO_ARGS_CONSTRUCTOR = new AnnotationMatcher("@lombok.NoArgsConstructor");

    public String getDisplayName() {
        return "Migrate Lombok's `@__` syntax to `onX_` for Java 8+";
    }

    public String getDescription() {
        return "Migrates Lombok's `onX` annotations from the Java 7 style using `@__` to the Java 8+ style using `onX_`. For example, `@Getter(onMethod=@__({@Id}))` becomes `@Getter(onMethod_={@Id})`.";
    }

    public Set<String> getTags() {
        return Collections.singleton("lombok");
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType("lombok.*", Boolean.valueOf(false)), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.Annotation visitAnnotation(J.Annotation annotation, ExecutionContext ctx) {
                J.Annotation a = super.visitAnnotation(annotation, (Object)ctx);
                if (this.isLombokAnnotationWithOnX(a) && a.getArguments() != null && !a.getArguments().isEmpty()) {
                    a = a.withArguments(ListUtils.map((List)a.getArguments(), arg -> {
                        J.Annotation onXAnnotation;
                        J.Identifier id;
                        String name;
                        J.Assignment assignment;
                        if (arg instanceof J.Assignment && (assignment = (J.Assignment)arg).getVariable() instanceof J.Identifier && ("onMethod".equals(name = (id = (J.Identifier)assignment.getVariable()).getSimpleName()) || "onParam".equals(name) || "onConstructor".equals(name)) && assignment.getAssignment() instanceof J.Annotation && "__".equals((onXAnnotation = (J.Annotation)assignment.getAssignment()).getSimpleName()) && onXAnnotation.getArguments() != null && !onXAnnotation.getArguments().isEmpty()) {
                            J.Identifier on_ = id.withSimpleName(name + "_");
                            Expression newValue = (Expression)onXAnnotation.getArguments().get(0);
                            return assignment.withVariable((Expression)on_).withAssignment(newValue);
                        }
                        return arg;
                    }));
                }
                return a;
            }

            private boolean isLombokAnnotationWithOnX(J.Annotation annotation) {
                return LOMBOK_GETTER.matches(annotation) || LOMBOK_SETTER.matches(annotation) || LOMBOK_WITH.matches(annotation) || LOMBOK_WITHER.matches(annotation) || LOMBOK_EQUALS_AND_HASHCODE.matches(annotation) || LOMBOK_TO_STRING.matches(annotation) || LOMBOK_REQUIRED_ARGS_CONSTRUCTOR.matches(annotation) || LOMBOK_ALL_ARGS_CONSTRUCTOR.matches(annotation) || LOMBOK_NO_ARGS_CONSTRUCTOR.matches(annotation);
            }
        });
    }
}

