/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.guava;

import java.util.Collections;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class NoGuavaPrimitiveAsList
extends Recipe {
    private static final MethodMatcher METHOD_MATCHER = new MethodMatcher("com.google.common.primitives.* asList(..)");

    public String getDisplayName() {
        return "Prefer `Arrays.asList(..)` over Guava primitives";
    }

    public String getDescription() {
        return "Migrate from Guava `com.google.common.primitives.* asList(..)` to `Arrays.asList(..)`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod("com.google.common.primitives.* asList(..)"), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                if (METHOD_MATCHER.matches((MethodCall)elem)) {
                    this.maybeRemoveImport("com.google.common.primitives.Booleans");
                    this.maybeRemoveImport("com.google.common.primitives.Chars");
                    this.maybeRemoveImport("com.google.common.primitives.Doubles");
                    this.maybeRemoveImport("com.google.common.primitives.Floats");
                    this.maybeRemoveImport("com.google.common.primitives.Longs");
                    this.maybeRemoveImport("com.google.common.primitives.Ints");
                    this.maybeRemoveImport("com.google.common.primitives.Shorts");
                    this.maybeRemoveImport("com.google.common.primitives.Bytes");
                    this.maybeAddImport("java.util.Arrays");
                    String args = String.join((CharSequence)",", Collections.nCopies(elem.getArguments().size(), "#{any()}"));
                    return (J.MethodInvocation)JavaTemplate.builder((String)("Arrays.asList(" + args + ')')).imports(new String[]{"java.util.Arrays"}).build().apply(this.getCursor(), elem.getCoordinates().replace(), elem.getArguments().toArray());
                }
                return super.visitMethodInvocation(elem, (Object)ctx);
            }
        });
    }
}

