/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.lang.var;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.migrate.lang.var.DeclarationCheck;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

public final class UseVarForPrimitive
extends Recipe {
    public String getDisplayName() {
        return "Use `var` for primitive-typed variables";
    }

    public String getDescription() {
        return "Try to apply local variable type inference `var` to primitive variables where possible. This recipe will not touch variable declarations with initializers containing ternary operators.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesJavaVersion(10), (TreeVisitor)new VarForPrimitivesVisitor());
    }

    @Generated
    public UseVarForPrimitive() {
    }

    @NonNull
    @Generated
    public String toString() {
        return "UseVarForPrimitive()";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UseVarForPrimitive)) {
            return false;
        }
        UseVarForPrimitive other = (UseVarForPrimitive)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof UseVarForPrimitive;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    static final class VarForPrimitivesVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        VarForPrimitivesVisitor() {
        }

        public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations vd, ExecutionContext ctx) {
            vd = super.visitVariableDeclarations(vd, (Object)ctx);
            boolean isGeneralApplicable = DeclarationCheck.isVarApplicable(this.getCursor(), vd);
            if (!isGeneralApplicable) {
                return vd;
            }
            boolean isNoPrimitive = !DeclarationCheck.isPrimitive(vd);
            boolean isByteVariable = DeclarationCheck.declarationHasType(vd, (JavaType)JavaType.Primitive.Byte);
            boolean isShortVariable = DeclarationCheck.declarationHasType(vd, (JavaType)JavaType.Primitive.Short);
            if (isNoPrimitive || isByteVariable || isShortVariable) {
                return vd;
            }
            J.VariableDeclarations finalVd = vd;
            return DeclarationCheck.transformToVar(vd, it -> it instanceof J.Literal ? this.expandWithPrimitivTypeHint(finalVd, (Expression)it) : it);
        }

        private Expression expandWithPrimitivTypeHint(J.VariableDeclarations vd, Expression initializer) {
            String valueSource = ((J.Literal)initializer).getValueSource();
            if (valueSource == null) {
                return initializer;
            }
            boolean isLongLiteral = JavaType.Primitive.Long == vd.getType();
            boolean inferredAsLong = valueSource.endsWith("l") || valueSource.endsWith("L");
            boolean isFloatLiteral = JavaType.Primitive.Float == vd.getType();
            boolean inferredAsFloat = valueSource.endsWith("f") || valueSource.endsWith("F");
            boolean isDoubleLiteral = JavaType.Primitive.Double == vd.getType();
            boolean inferredAsDouble = valueSource.endsWith("d") || valueSource.endsWith("D") || valueSource.contains(".");
            String typNotation = null;
            if (isLongLiteral && !inferredAsLong) {
                typNotation = "L";
            } else if (isFloatLiteral && !inferredAsFloat) {
                typNotation = "F";
            } else if (isDoubleLiteral && !inferredAsDouble) {
                typNotation = "D";
            }
            if (typNotation != null) {
                initializer = ((J.Literal)initializer).withValueSource(String.format("%s%s", valueSource, typNotation));
            }
            return initializer;
        }
    }
}

