/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.lang.var;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.migrate.lang.var.DeclarationCheck;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.JavaVarKeyword;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.marker.Markers;

public class UseVarForGenericsConstructors
extends Recipe {
    public String getDisplayName() {
        return "Apply `var` to Generic Constructors";
    }

    public String getDescription() {
        return "Apply `var` to generics variables initialized by constructor calls.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesJavaVersion(10), (TreeVisitor)new UseVarForGenericsConstructorsVisitor());
    }

    static final class UseVarForGenericsConstructorsVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        UseVarForGenericsConstructorsVisitor() {
        }

        public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations vd, ExecutionContext ctx) {
            vd = super.visitVariableDeclarations(vd, (Object)ctx);
            boolean isGeneralApplicable = DeclarationCheck.isVarApplicable(this.getCursor(), vd);
            if (!isGeneralApplicable) {
                return vd;
            }
            boolean isPrimitive = DeclarationCheck.isPrimitive(vd);
            boolean usesNoGenerics = !DeclarationCheck.useGenerics(vd);
            boolean usesTernary = DeclarationCheck.initializedByTernary(vd);
            if (isPrimitive || usesTernary || usesNoGenerics) {
                return vd;
            }
            J.VariableDeclarations.NamedVariable variable = (J.VariableDeclarations.NamedVariable)vd.getVariables().get(0);
            List<JavaType> leftTypes = this.extractTypeParameters(variable.getVariableType());
            List<JavaType> rightTypes = this.extractTypeParameters(variable.getInitializer());
            if (rightTypes == null || leftTypes.isEmpty() && rightTypes.isEmpty()) {
                return vd;
            }
            boolean genericHasBounds = UseVarForGenericsConstructorsVisitor.anyTypeHasBounds(leftTypes);
            if (genericHasBounds) {
                return vd;
            }
            if (vd.getType() instanceof JavaType.FullyQualified) {
                this.maybeRemoveImport((JavaType.FullyQualified)vd.getType());
            }
            return this.transformToVar(vd, leftTypes, rightTypes);
        }

        private static Boolean anyTypeHasBounds(List<JavaType> leftTypes) {
            for (JavaType type : leftTypes) {
                if (type instanceof JavaType.Parameterized) {
                    return UseVarForGenericsConstructorsVisitor.anyTypeHasBounds(((JavaType.Parameterized)type).getTypeParameters());
                }
                if (!(type instanceof JavaType.GenericTypeVariable)) continue;
                return !((JavaType.GenericTypeVariable)type).getBounds().isEmpty();
            }
            return false;
        }

        private @Nullable List<JavaType> extractTypeParameters(@Nullable Expression initializer) {
            TypeTree clazz;
            if (initializer instanceof J.NewClass && (clazz = ((J.NewClass)initializer).getClazz()) instanceof J.ParameterizedType) {
                List typeParameters = ((J.ParameterizedType)clazz).getTypeParameters();
                ArrayList<JavaType> params = new ArrayList<JavaType>();
                if (typeParameters != null) {
                    for (Expression curType : typeParameters) {
                        JavaType type = curType.getType();
                        if (type == null) continue;
                        params.add(type);
                    }
                }
                return params;
            }
            return null;
        }

        private List<JavaType> extractTypeParameters(// Could not load outer class - annotation placement on inner may be incorrect
        @Nullable JavaType.Variable variable) {
            if (variable != null && variable.getType() instanceof JavaType.Parameterized) {
                return ((JavaType.Parameterized)variable.getType()).getTypeParameters();
            }
            return new ArrayList<JavaType>();
        }

        private J.VariableDeclarations transformToVar(J.VariableDeclarations vd, List<JavaType> leftTypes, List<JavaType> rightTypes) {
            J.NewClass initializer = Objects.requireNonNull((J.NewClass)((J.VariableDeclarations.NamedVariable)vd.getVariables().get(0)).getInitializer());
            if (rightTypes.isEmpty() && !leftTypes.isEmpty() && vd.getTypeExpression() instanceof J.ParameterizedType && initializer.getClazz() instanceof J.ParameterizedType) {
                J.ParameterizedType typedInitializerClazz = ((J.ParameterizedType)initializer.getClazz()).withTypeParameters(((J.ParameterizedType)vd.getTypeExpression()).getTypeParameters());
                initializer = initializer.withClazz((TypeTree)typedInitializerClazz);
            }
            J.NewClass finalInitializer = initializer;
            List variables = ListUtils.mapFirst((List)vd.getVariables(), it -> {
                JavaType.Variable variableType = it.getVariableType() == null ? null : it.getVariableType().withOwner(null);
                return it.withName(it.getName().withType(finalInitializer.getType()).withFieldType(variableType)).withInitializer((Expression)finalInitializer).withVariableType(variableType);
            });
            J.Identifier typeExpression = new J.Identifier(Tree.randomId(), vd.getTypeExpression().getPrefix(), Markers.build(Collections.singleton(JavaVarKeyword.build())), Collections.emptyList(), "var", initializer.getType(), null);
            return vd.withVariables(variables).withTypeExpression((TypeTree)typeExpression);
        }
    }
}

