/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.lang.var;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.migrate.lang.var.DeclarationCheck;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.marker.Markers;

public class UseVarForGenericsConstructors
extends Recipe {
    public String getDisplayName() {
        return "Apply `var` to Generic Constructors";
    }

    public String getDescription() {
        return "Apply `var` to generics variables initialized by constructor calls.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesJavaVersion(10), (TreeVisitor)new UseVarForGenericsConstructorsVisitor());
    }

    static final class UseVarForGenericsConstructorsVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private final JavaTemplate template = JavaTemplate.builder((String)"var #{} = #{any()}").javaParser(JavaParser.fromJavaVersion()).build();

        UseVarForGenericsConstructorsVisitor() {
        }

        public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations vd, ExecutionContext ctx) {
            vd = super.visitVariableDeclarations(vd, (Object)ctx);
            boolean isGeneralApplicable = DeclarationCheck.isVarApplicable(this.getCursor(), vd);
            if (!isGeneralApplicable) {
                return vd;
            }
            boolean isPrimitive = DeclarationCheck.isPrimitive(vd);
            boolean usesNoGenerics = !DeclarationCheck.useGenerics(vd);
            boolean usesTernary = DeclarationCheck.initializedByTernary(vd);
            if (isPrimitive || usesTernary || usesNoGenerics) {
                return vd;
            }
            J.VariableDeclarations.NamedVariable variable = (J.VariableDeclarations.NamedVariable)vd.getVariables().get(0);
            List<JavaType> leftTypes = this.extractParameters(variable.getVariableType());
            List<JavaType> rightTypes = this.extractParameters(variable.getInitializer());
            if (rightTypes == null || leftTypes.isEmpty() && rightTypes.isEmpty()) {
                return vd;
            }
            for (JavaType type : leftTypes) {
                if (!UseVarForGenericsConstructorsVisitor.hasBounds(type)) continue;
                return vd;
            }
            boolean genericHasBounds = UseVarForGenericsConstructorsVisitor.anyTypeHasBounds(leftTypes);
            if (genericHasBounds) {
                return vd;
            }
            if (vd.getType() instanceof JavaType.FullyQualified) {
                this.maybeRemoveImport((JavaType.FullyQualified)vd.getType());
            }
            return this.transformToVar(vd, leftTypes, rightTypes);
        }

        @NotNull
        private static Boolean anyTypeHasBounds(List<JavaType> leftTypes) {
            for (JavaType type : leftTypes) {
                if (!UseVarForGenericsConstructorsVisitor.hasBounds(type)) continue;
                return true;
            }
            return false;
        }

        private static boolean hasBounds(JavaType type) {
            if (type instanceof JavaType.Parameterized) {
                return UseVarForGenericsConstructorsVisitor.anyTypeHasBounds(((JavaType.Parameterized)type).getTypeParameters());
            }
            if (type instanceof JavaType.GenericTypeVariable) {
                return !((JavaType.GenericTypeVariable)type).getBounds().isEmpty();
            }
            return false;
        }

        @Nullable
        private List<JavaType> extractParameters(@Nullable Expression initializer) {
            TypeTree clazz;
            if (initializer instanceof J.NewClass && (clazz = ((J.NewClass)initializer).getClazz()) instanceof J.ParameterizedType) {
                List typeParameters = ((J.ParameterizedType)clazz).getTypeParameters();
                ArrayList<JavaType> params = new ArrayList<JavaType>();
                if (typeParameters != null) {
                    for (Expression curType : typeParameters) {
                        JavaType type = curType.getType();
                        if (type == null) continue;
                        params.add(type);
                    }
                }
                return params;
            }
            return null;
        }

        private List<JavaType> extractParameters(@Nullable JavaType.Variable variable) {
            if (variable != null && variable.getType() instanceof JavaType.Parameterized) {
                return ((JavaType.Parameterized)variable.getType()).getTypeParameters();
            }
            return new ArrayList<JavaType>();
        }

        private J.VariableDeclarations transformToVar(J.VariableDeclarations vd, List<JavaType> leftTypes, List<JavaType> rightTypes) {
            TypeTree resultingTypeExpression;
            boolean resultHasTypeExpression;
            boolean hasModifiers;
            Expression initializer = ((J.VariableDeclarations.NamedVariable)vd.getVariables().get(0)).getInitializer();
            String simpleName = ((J.VariableDeclarations.NamedVariable)vd.getVariables().get(0)).getSimpleName();
            if (rightTypes.isEmpty() && !leftTypes.isEmpty()) {
                ArrayList<Expression> typeExpressions = new ArrayList<Expression>();
                for (JavaType curType : leftTypes) {
                    typeExpressions.add(UseVarForGenericsConstructorsVisitor.typeToExpression(curType));
                }
                J.ParameterizedType typedInitializerClazz = ((J.ParameterizedType)((J.NewClass)initializer).getClazz()).withTypeParameters(typeExpressions);
                initializer = ((J.NewClass)initializer).withClazz((TypeTree)typedInitializerClazz);
            }
            J.VariableDeclarations result = ((J.VariableDeclarations)this.template.apply(this.getCursor(), vd.getCoordinates().replace(), new Object[]{simpleName, initializer})).withPrefix(vd.getPrefix());
            List modifiers = vd.getModifiers();
            boolean bl = hasModifiers = !modifiers.isEmpty();
            if (hasModifiers) {
                result = result.withModifiers(modifiers);
            }
            boolean bl2 = resultHasTypeExpression = (resultingTypeExpression = result.getTypeExpression()) != null;
            if (resultHasTypeExpression) {
                result = result.withTypeExpression((TypeTree)resultingTypeExpression.withPrefix(vd.getTypeExpression().getPrefix()));
            }
            return result;
        }

        private static Expression typeToExpression(JavaType type) {
            if (type instanceof JavaType.Primitive) {
                JavaType.Primitive primitiveType = JavaType.Primitive.fromKeyword((String)((JavaType.Primitive)type).getKeyword());
                return new J.Primitive(Tree.randomId(), Space.EMPTY, Markers.EMPTY, primitiveType);
            }
            if (type instanceof JavaType.Class) {
                String className = ((JavaType.Class)type).getClassName();
                return new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), className, type, null);
            }
            if (type instanceof JavaType.Array) {
                TypeTree elemType = (TypeTree)UseVarForGenericsConstructorsVisitor.typeToExpression(((JavaType.Array)type).getElemType());
                return new J.ArrayType(Tree.randomId(), Space.EMPTY, Markers.EMPTY, elemType, null, JLeftPadded.build((Object)Space.EMPTY), type);
            }
            if (type instanceof JavaType.GenericTypeVariable) {
                String variableName = ((JavaType.GenericTypeVariable)type).getName();
                J.Identifier identifier = new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), variableName, type, null);
                List bounds1 = ((JavaType.GenericTypeVariable)type).getBounds();
                if (bounds1.isEmpty()) {
                    return identifier;
                }
                throw new IllegalStateException("Generic type variables with bound are not supported, yet.");
            }
            if (type instanceof JavaType.Parameterized) {
                List typeParameters = ((JavaType.Parameterized)type).getTypeParameters();
                ArrayList<JRightPadded> typeParamsExpression = new ArrayList<JRightPadded>(typeParameters.size());
                for (JavaType curType : typeParameters) {
                    typeParamsExpression.add(JRightPadded.build((Object)UseVarForGenericsConstructorsVisitor.typeToExpression(curType)));
                }
                J.Identifier clazz = new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), ((JavaType.Parameterized)type).getClassName(), null, null);
                return new J.ParameterizedType(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (NameTree)clazz, JContainer.build(typeParamsExpression), type);
            }
            throw new IllegalArgumentException(String.format("Unable to parse expression from JavaType %s", type));
        }
    }
}

