/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate;

import java.beans.ConstructorProperties;
import java.util.Objects;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.format.NormalizeTabsOrSpacesVisitor;
import org.openrewrite.java.style.IntelliJ;
import org.openrewrite.java.style.TabsAndIndentsStyle;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;

public final class UseTabsOrSpaces
extends Recipe {
    @Option(displayName="Use tabs", description="Whether to use tabs for indentation.")
    private final boolean useTabs;

    public String getDisplayName() {
        return "Force indentation to either tabs or spaces";
    }

    public String getDescription() {
        return "This is useful for one-off migrations of a codebase that has mixed indentation styles, while preserving all other auto-detected formatting rules.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree instanceof JavaSourceFile) {
                    JavaSourceFile cu = (JavaSourceFile)Objects.requireNonNull(tree);
                    TabsAndIndentsStyle style = (TabsAndIndentsStyle)((SourceFile)cu).getStyle(TabsAndIndentsStyle.class);
                    if (style == null) {
                        style = IntelliJ.tabsAndIndents();
                    }
                    style = style.withUseTabCharacter(Boolean.valueOf(UseTabsOrSpaces.this.useTabs));
                    return new NormalizeTabsOrSpacesVisitor(style).visit(tree, (Object)ctx);
                }
                return (J)tree;
            }
        };
    }

    @ConstructorProperties(value={"useTabs"})
    public UseTabsOrSpaces(boolean useTabs) {
        this.useTabs = useTabs;
    }

    public boolean isUseTabs() {
        return this.useTabs;
    }

    @NonNull
    public String toString() {
        return "UseTabsOrSpaces(useTabs=" + this.isUseTabs() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UseTabsOrSpaces)) {
            return false;
        }
        UseTabsOrSpaces other = (UseTabsOrSpaces)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return this.isUseTabs() == other.isUseTabs();
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof UseTabsOrSpaces;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isUseTabs() ? 79 : 97);
        return result;
    }
}

