/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.lang;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.HasJavaVersion;
import org.openrewrite.java.style.IntelliJ;
import org.openrewrite.java.style.TabsAndIndentsStyle;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;
import org.openrewrite.staticanalysis.kotlin.KotlinFileChecker;

public final class UseTextBlocks
extends Recipe {
    @Option(displayName="Whether to convert strings without newlines (the default value is true).", description="Whether or not strings without newlines should be converted to text block when processing code. The default value is true.", example="true", required=false)
    private final @Nullable boolean convertStringsWithoutNewlines;

    public UseTextBlocks() {
        this.convertStringsWithoutNewlines = true;
    }

    public UseTextBlocks(boolean convertStringsWithoutNewlines) {
        this.convertStringsWithoutNewlines = convertStringsWithoutNewlines;
    }

    public String getDisplayName() {
        return "Use text blocks";
    }

    public String getDescription() {
        return "Text blocks are easier to read than concatenated strings.";
    }

    public @Nullable Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(3L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        TreeVisitor preconditions = Preconditions.and((TreeVisitor[])new TreeVisitor[]{Preconditions.not((TreeVisitor)new KotlinFileChecker()), new HasJavaVersion("17", Boolean.valueOf(true)).getVisitor()});
        return Preconditions.check((TreeVisitor)preconditions, (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J visitBinary(J.Binary binary, ExecutionContext ctx) {
                ArrayList<J.Literal> stringLiterals = new ArrayList<J.Literal>();
                StringBuilder contentSb = new StringBuilder();
                StringBuilder concatenationSb = new StringBuilder();
                boolean allLiterals = UseTextBlocks.allLiterals((Expression)binary);
                if (!allLiterals) {
                    return binary;
                }
                boolean flattenable = UseTextBlocks.flatAdditiveStringLiterals((Expression)binary, stringLiterals, contentSb, concatenationSb);
                if (!flattenable) {
                    return super.visitBinary(binary, (Object)ctx);
                }
                boolean hasNewLineInConcatenation = UseTextBlocks.containsNewLineInContent(concatenationSb.toString());
                if (!hasNewLineInConcatenation) {
                    return super.visitBinary(binary, (Object)ctx);
                }
                String content = contentSb.toString();
                if (!UseTextBlocks.this.convertStringsWithoutNewlines && !UseTextBlocks.containsNewLineInContent(content)) {
                    return super.visitBinary(binary, (Object)ctx);
                }
                return this.toTextBlock(binary, content, stringLiterals, concatenationSb.toString());
            }

            private J.Literal toTextBlock(J.Binary binary, String content, List<J.Literal> stringLiterals, String concatenation) {
                String passPhrase;
                try {
                    passPhrase = UseTextBlocks.generatePassword(content);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException(e);
                }
                StringBuilder sb = new StringBuilder();
                StringBuilder originalContent = new StringBuilder();
                stringLiterals = stringLiterals.stream().filter(s -> !s.getValue().toString().isEmpty()).collect(Collectors.toList());
                for (int i = 0; i < stringLiterals.size(); ++i) {
                    String s2 = ((J.Literal)stringLiterals.get(i)).getValue().toString();
                    sb.append(s2);
                    originalContent.append(s2);
                    if (i == stringLiterals.size() - 1) continue;
                    String nextLine = ((J.Literal)stringLiterals.get(i + 1)).getValue().toString();
                    char nextChar = nextLine.charAt(0);
                    if (s2.endsWith("\n") || nextChar == '\n') continue;
                    sb.append(passPhrase);
                }
                content = sb.toString();
                TabsAndIndentsStyle tabsAndIndentsStyle = Optional.ofNullable((TabsAndIndentsStyle)((SourceFile)this.getCursor().firstEnclosingOrThrow(SourceFile.class)).getStyle(TabsAndIndentsStyle.class)).orElse(IntelliJ.tabsAndIndents());
                boolean useTab = tabsAndIndentsStyle.getUseTabCharacter();
                int tabSize = tabsAndIndentsStyle.getTabSize();
                String indentation = UseTextBlocks.getIndents(concatenation, useTab, tabSize);
                boolean isEndsWithNewLine = content.endsWith("\n");
                content = content.replace("\\", "\\\\");
                content = content.replace("\"\"\"", "\"\"\\\"");
                content = content.replace(" \n", "\\s\n");
                content = content.replace("\n", "\n" + indentation);
                content = content.replace(passPhrase, "\\\n" + indentation);
                content = "\n" + indentation + content;
                if (!isEndsWithNewLine) {
                    content = content + "\\\n" + indentation;
                }
                return new J.Literal(Tree.randomId(), binary.getPrefix(), Markers.EMPTY, (Object)originalContent.toString(), String.format("\"\"\"%s\"\"\"", content), null, JavaType.Primitive.String);
            }
        });
    }

    private static boolean allLiterals(Expression exp) {
        return UseTextBlocks.isRegularStringLiteral(exp) || exp instanceof J.Binary && ((J.Binary)exp).getOperator() == J.Binary.Type.Addition && UseTextBlocks.allLiterals(((J.Binary)exp).getLeft()) && UseTextBlocks.allLiterals(((J.Binary)exp).getRight());
    }

    private static boolean flatAdditiveStringLiterals(Expression expression, List<J.Literal> stringLiterals, StringBuilder contentSb, StringBuilder concatenationSb) {
        if (expression instanceof J.Binary) {
            J.Binary b = (J.Binary)expression;
            if (b.getOperator() != J.Binary.Type.Addition) {
                return false;
            }
            concatenationSb.append(b.getPrefix().getWhitespace()).append("-");
            concatenationSb.append(b.getPadding().getOperator().getBefore().getWhitespace()).append("-");
            return UseTextBlocks.flatAdditiveStringLiterals(b.getLeft(), stringLiterals, contentSb, concatenationSb) && UseTextBlocks.flatAdditiveStringLiterals(b.getRight(), stringLiterals, contentSb, concatenationSb);
        }
        if (UseTextBlocks.isRegularStringLiteral(expression)) {
            J.Literal l = (J.Literal)expression;
            stringLiterals.add(l);
            contentSb.append(l.getValue().toString());
            concatenationSb.append(l.getPrefix().getWhitespace()).append("-");
            return true;
        }
        return false;
    }

    private static boolean isRegularStringLiteral(Expression expr) {
        if (expr instanceof J.Literal) {
            J.Literal l = (J.Literal)expr;
            return TypeUtils.isString((JavaType)l.getType()) && l.getValueSource() != null && !l.getValueSource().startsWith("\"\"\"");
        }
        return false;
    }

    private static boolean containsNewLineInContent(String content) {
        for (int i = 0; i < content.length() - 1; ++i) {
            char c = content.charAt(i);
            if (c != '\n') continue;
            return true;
        }
        return false;
    }

    private static String getIndents(String concatenation, boolean useTabCharacter, int tabSize) {
        int[] tabAndSpaceCounts = UseTextBlocks.shortestPrefixAfterNewline(concatenation, tabSize);
        int tabCount = tabAndSpaceCounts[0];
        int spaceCount = tabAndSpaceCounts[1];
        if (useTabCharacter) {
            return StringUtils.repeat((String)"\t", (int)tabCount) + StringUtils.repeat((String)" ", (int)spaceCount);
        }
        return StringUtils.repeat((String)" ", (int)(tabCount * tabSize + spaceCount));
    }

    private static int[] shortestPrefixAfterNewline(String concatenation, int tabSize) {
        int shortest = Integer.MAX_VALUE;
        int[] shortestPair = new int[]{0, 0};
        int tabCount = 0;
        int spaceCount = 0;
        boolean afterNewline = false;
        for (int i = 0; i < concatenation.length(); ++i) {
            char c = concatenation.charAt(i);
            if (c != ' ' && c != '\t' && afterNewline) {
                if (spaceCount + tabCount * tabSize < shortest) {
                    shortest = spaceCount + tabCount;
                    shortestPair[0] = tabCount;
                    shortestPair[1] = spaceCount;
                }
                afterNewline = false;
            }
            if (c == '\n') {
                afterNewline = true;
                spaceCount = 0;
                tabCount = 0;
                continue;
            }
            if (c == ' ') {
                if (!afterNewline) continue;
                ++spaceCount;
                continue;
            }
            if (c == '\t') {
                if (!afterNewline) continue;
                ++tabCount;
                continue;
            }
            afterNewline = false;
            spaceCount = 0;
            tabCount = 0;
        }
        if (spaceCount + tabCount > 0 && spaceCount + tabCount < shortest) {
            shortestPair[0] = tabCount;
            shortestPair[1] = spaceCount;
        }
        return shortestPair;
    }

    private static String generatePassword(String originalStr) throws NoSuchAlgorithmException {
        String SALT = "kun";
        String password = "";
        String saltedStr = originalStr + "kun";
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        byte[] hashBytes = md.digest(saltedStr.getBytes());
        password = Base64.getEncoder().encodeToString(hashBytes);
        while (originalStr.contains(password)) {
            hashBytes = md.digest(password.getBytes());
            password = Base64.getEncoder().encodeToString(hashBytes);
        }
        return password;
    }

    @Generated
    public @Nullable boolean isConvertStringsWithoutNewlines() {
        return this.convertStringsWithoutNewlines;
    }

    @NonNull
    @Generated
    public String toString() {
        return "UseTextBlocks(convertStringsWithoutNewlines=" + this.isConvertStringsWithoutNewlines() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UseTextBlocks)) {
            return false;
        }
        UseTextBlocks other = (UseTextBlocks)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return this.isConvertStringsWithoutNewlines() == other.isConvertStringsWithoutNewlines();
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof UseTextBlocks;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isConvertStringsWithoutNewlines() ? 79 : 97);
        return result;
    }
}

