/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.net;

import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.AddImport;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;

public class MigrateURLDecoderDecode
extends Recipe {
    private static final MethodMatcher MATCHER = new MethodMatcher("java.net.URLDecoder decode(String)");

    public String getDisplayName() {
        return "Use `java.net.URLDecoder#decode(String, StandardCharsets.UTF_8)`";
    }

    public String getDescription() {
        return "Use `java.net.URLDecoder#decode(String, StandardCharsets.UTF_8)` instead of the deprecated `java.net.URLDecoder#decode(String)` in Java 10 or higher.";
    }

    public Set<String> getTags() {
        return Collections.singleton("deprecated");
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesJavaVersion(10), new UsesMethod(MATCHER)}), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = method;
                if (MATCHER.matches(m)) {
                    m = (J.MethodInvocation)JavaTemplate.builder((String)"#{any(String)}, StandardCharsets.UTF_8").contextSensitive().imports(new String[]{"java.nio.charset.StandardCharsets"}).build().apply(this.getCursor(), m.getCoordinates().replaceArguments(), m.getArguments().toArray());
                    this.doAfterVisit((TreeVisitor)new AddImport("java.nio.charset.StandardCharsets", null, false));
                }
                return super.visitMethodInvocation(m, (Object)ctx);
            }
        });
    }
}

