/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.guava;

import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class NoGuavaSetsNewHashSet
extends Recipe {
    private static final MethodMatcher NEW_HASH_SET = new MethodMatcher("com.google.common.collect.Sets newHashSet(..)");

    public String getDisplayName() {
        return "Prefer `new HashSet<>()`";
    }

    public String getDescription() {
        return "Prefer the Java standard library over third-party usage of Guava in simple cases like this.";
    }

    public Set<String> getTags() {
        return Collections.singleton("guava");
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(NEW_HASH_SET), (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                if (NEW_HASH_SET.matches(method)) {
                    this.maybeRemoveImport("com.google.common.collect.Sets");
                    this.maybeAddImport("java.util.HashSet");
                    if (method.getArguments().isEmpty() || !method.getArguments().isEmpty() && method.getArguments().get(0) instanceof J.Empty) {
                        return JavaTemplate.builder((String)"new HashSet<>()").contextSensitive().imports(new String[]{"java.util.HashSet"}).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[0]);
                    }
                    if (method.getArguments().size() == 1 && TypeUtils.isAssignableTo((String)"java.util.Collection", (JavaType)((Expression)method.getArguments().get(0)).getType())) {
                        return JavaTemplate.builder((String)"new HashSet<>(#{any(java.util.Collection)})").contextSensitive().imports(new String[]{"java.util.HashSet"}).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{method.getArguments().get(0)});
                    }
                    this.maybeAddImport("java.util.Arrays");
                    JavaTemplate newHashSetVarargs = JavaTemplate.builder((String)("new HashSet<>(Arrays.asList(" + method.getArguments().stream().map(a -> "#{any()}").collect(Collectors.joining(",")) + "))")).contextSensitive().imports(new String[]{"java.util.Arrays"}).imports(new String[]{"java.util.HashSet"}).build();
                    return newHashSetVarargs.apply(this.getCursor(), method.getCoordinates().replace(), method.getArguments().toArray());
                }
                return super.visitMethodInvocation(method, (Object)ctx);
            }
        });
    }
}

