/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.lang;

import java.time.Duration;
import java.util.List;
import java.util.StringJoiner;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.template.SourceTemplate;

public class MigrateCollectionsSingletonMap
extends Recipe {
    private static final MethodMatcher SINGLETON_MAP = new MethodMatcher("java.util.Collections singletonMap(..)", true);

    public String getDisplayName() {
        return "Use `Map.of(..)` in Java 9 or higher";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public String getDescription() {
        return "Replaces `Collections.singletonMap(<args>)))` with `Map.Of(<args>)`.";
    }

    protected JavaVisitor<ExecutionContext> getSingleSourceApplicableTest() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext executionContext) {
                this.doAfterVisit((TreeVisitor)new UsesJavaVersion(9));
                this.doAfterVisit((TreeVisitor)new UsesMethod(SINGLETON_MAP));
                return cu;
            }
        };
    }

    protected JavaVisitor<ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
                J.MethodInvocation m = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)executionContext);
                if (SINGLETON_MAP.matches(method)) {
                    this.maybeRemoveImport("java.util.Collections");
                    StringJoiner mapOf = new StringJoiner(", ", "Map.of(", ")");
                    List args = m.getArguments();
                    args.forEach(o -> mapOf.add("#{any()}"));
                    return this.autoFormat(m.withTemplate((SourceTemplate)JavaTemplate.builder(() -> (this).getCursor(), (String)mapOf.toString()).imports(new String[]{"java.util.Map"}).build(), m.getCoordinates().replace(), m.getArguments().toArray()), executionContext);
                }
                return m;
            }
        };
    }
}

